/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.camol.event;

import cy.jdkdigital.camol.Camol;
import cy.jdkdigital.camol.common.item.CamoItem;
import cy.jdkdigital.camol.event.ClientEventHandler;
import cy.jdkdigital.camol.network.ClearCamoData;
import cy.jdkdigital.camol.network.SyncChunkCamoData;
import cy.jdkdigital.camol.utils.CamoPosition;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="camol")
public class EventHandler {
    @SubscribeEvent
    public static void chunkWatch(ChunkWatchEvent.Sent event) {
        HashMap<String, CamoPosition> camoMap = new HashMap<String, CamoPosition>((Map)event.getChunk().getData(Camol.CAMO_BLOCK_MAP));
        boolean hasUpdate = false;
        for (Map.Entry entry : ((Map)event.getChunk().getData(Camol.OLD_CAMO_BLOCK_MAP)).entrySet()) {
            if (!((BlockState)entry.getValue()).isAir()) {
                camoMap.put((String)entry.getKey(), new CamoPosition("normal", (BlockState)entry.getValue()));
            }
            hasUpdate = true;
        }
        if (hasUpdate) {
            event.getChunk().setData(Camol.CAMO_BLOCK_MAP, camoMap);
            event.getChunk().removeData(Camol.OLD_CAMO_BLOCK_MAP);
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)event.getLevel(), (ChunkPos)event.getPos(), (CustomPacketPayload)new SyncChunkCamoData(camoMap, event.getPos().getWorldPosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void playerTick(PlayerTickEvent.Post event) {
        if (event.getEntity().level().isClientSide) {
            ClientEventHandler.shouldBeTransparent = event.getEntity().getMainHandItem().is(Camol.CAMO_ITEM) || event.getEntity().getOffhandItem().is(Camol.SOLID_CAMO_ITEM) || event.getEntity().getMainHandItem().is(Camol.SOLID_CAMO_ITEM) || event.getEntity().getOffhandItem().is(Camol.SOLID_CAMO_ITEM);
        }
    }

    @SubscribeEvent
    public static void dimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new ClearCamoData("dimension_change"), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void blockBreak(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            String posKey = String.valueOf(event.getPos().asLong());
            LevelChunk chunk = serverLevel.getChunkAt(event.getPos());
            HashMap<String, CamoPosition> camoMap = new HashMap<String, CamoPosition>((Map)chunk.getData(Camol.CAMO_BLOCK_MAP));
            if (camoMap.containsKey(posKey)) {
                CamoPosition camoPosition = (CamoPosition)camoMap.get(posKey);
                if (!camoPosition.state().isAir()) {
                    Block.popResource((Level)serverLevel, (BlockPos)event.getPos(), (ItemStack)CamoItem.getCamoItem(camoPosition.state(), camoPosition.camoType().equals("solid")));
                }
                camoMap.put(posKey, new CamoPosition("normal", Blocks.AIR.defaultBlockState()));
                chunk.setData(Camol.CAMO_BLOCK_MAP, camoMap);
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(event.getPos()), (CustomPacketPayload)new SyncChunkCamoData(camoMap, event.getPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

