/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.arcade.tetris;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.arcade.ArcadeGame;
import vswe.stevescarts.arcade.tetris.TetrisBlock;
import vswe.stevescarts.arcade.tetris.TetrisPiece;
import vswe.stevescarts.arcade.tracks.TrackStory;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.realtimers.ModuleArcade;

public class ArcadeTetris
extends ArcadeGame {
    private TetrisBlock[][] board;
    private TetrisPiece piece;
    private static SoundEvent[] removalSounds;
    private int ticks = 0;
    private boolean isPlaying = true;
    private boolean quickMove = false;
    private int gameOverTicks;
    private int highscore;
    private int score;
    private int removed;
    private int[] removedByAmount;
    private int delay = 10;
    private int piecesSinceDelayChange;
    private boolean newHighScore;
    public static final int BOARD_START_X = 189;
    public static final int BOARD_START_Y = 9;
    private static String texture;

    public ArcadeTetris(ModuleArcade module) {
        super(module, Localization.ARCADE.STACKER);
        this.newgame();
    }

    private void newgame() {
        this.board = new TetrisBlock[10][15];
        this.generatePiece();
        this.isPlaying = true;
        this.ticks = 0;
        this.quickMove = false;
        this.score = 0;
        this.removed = 0;
        this.removedByAmount = new int[4];
        this.delay = 10;
        this.piecesSinceDelayChange = 0;
        this.newHighScore = false;
    }

    private void generatePiece() {
        this.piece = TetrisPiece.createPiece(this.getModule().getCart().random.nextInt(7));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void update() {
        super.update();
        if (this.isPlaying) {
            if (this.ticks == 0 || this.quickMove) {
                if (this.piece != null) {
                    TetrisPiece.MOVE_RESULT result = this.piece.move(this, this.board, 0, 1, true);
                    if (result == TetrisPiece.MOVE_RESULT.FAIL) {
                        this.piece = null;
                        int removedCount = 0;
                        for (int y = 0; y < this.board[0].length; ++y) {
                            boolean valid = true;
                            for (int x = 0; x < this.board.length; ++x) {
                                if (this.board[x][y] != null) continue;
                                valid = false;
                                break;
                            }
                            if (!valid) continue;
                            for (int y2 = y; y2 >= 0; --y2) {
                                for (int x2 = 0; x2 < this.board.length; ++x2) {
                                    TetrisBlock value;
                                    this.board[x2][y2] = value = y2 == 0 ? null : this.board[x2][y2 - 1];
                                }
                            }
                            ++removedCount;
                        }
                        if (removedCount > 0) {
                            int n;
                            this.removed += removedCount;
                            int[] removedByAmount = this.removedByAmount;
                            int n2 = n = removedCount - 1;
                            removedByAmount[n2] = removedByAmount[n2] + 1;
                            this.score += removedCount * removedCount * 100;
                            ArcadeGame.playSound(removalSounds[removedCount - 1], 1.0f, 1.0f);
                        }
                        this.quickMove = false;
                        ++this.piecesSinceDelayChange;
                        if (this.piecesSinceDelayChange == 8) {
                            this.piecesSinceDelayChange = 0;
                            if (this.delay > 0) {
                                --this.delay;
                            }
                        }
                    } else if (result == TetrisPiece.MOVE_RESULT.GAME_OVER) {
                        this.piece = null;
                        this.isPlaying = false;
                        this.quickMove = false;
                        this.gameOverTicks = 0;
                        this.newHighScore();
                    }
                } else {
                    this.generatePiece();
                }
                this.ticks = this.delay;
            } else {
                --this.ticks;
            }
        } else if (this.gameOverTicks < 170) {
            this.gameOverTicks = Math.min(170, this.gameOverTicks + 5);
        } else if (this.newHighScore) {
            this.newHighScore = false;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource(texture);
        this.getModule().drawImage(guiGraphics, gui, 187, 7, 0, 40, 104, 154);
        for (int i = 0; i < this.board.length; ++i) {
            for (int j = 0; j < this.board[0].length; ++j) {
                TetrisBlock b = this.board[i][j];
                if (b == null) continue;
                b.render(guiGraphics, this, gui, i, j);
            }
        }
        if (this.piece != null) {
            this.piece.render(guiGraphics, this, gui);
        }
        if (!this.isPlaying) {
            int graphicalValue = Math.min(this.gameOverTicks, 150);
            this.getModule().drawImage(guiGraphics, gui, 189, 159 - graphicalValue, 104, 40, 100, graphicalValue);
            if (graphicalValue == 150 && this.getModule().inRect(x, y, new int[]{189, 9, 100, 150})) {
                this.getModule().drawImage(guiGraphics, gui, 213, 107, 0, 194, 54, 34);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void keyPress(GuiMinecart gui, int character, int extraInformation) {
        if (this.piece != null) {
            if (character == 19) {
                this.piece.rotate(this.board);
            } else if (character == 30) {
                this.piece.move(this, this.board, -1, 0, false);
            } else if (character == 32) {
                this.piece.move(this, this.board, 1, 0, false);
            } else if (character == 31) {
                this.quickMove = true;
            }
        }
        if (character == 19) {
            this.newgame();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && !this.isPlaying && this.gameOverTicks >= 150 && this.getModule().inRect(x, y, new int[]{189, 9, 100, 150})) {
            this.newgame();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.getModule().drawString(guiGraphics, gui, Localization.ARCADE.HIGH_SCORE.translate(String.valueOf(this.highscore)), 10, 20, 0x404040);
        this.getModule().drawString(guiGraphics, gui, Localization.ARCADE.SCORE.translate(String.valueOf(this.score)), 10, 40, 0x404040);
        this.getModule().drawString(guiGraphics, gui, Localization.ARCADE.REMOVED_LINES.translate(String.valueOf(this.removed)), 10, 60, 0x404040);
        for (int i = 0; i < 4; ++i) {
            this.getModule().drawString(guiGraphics, gui, Localization.ARCADE.REMOVED_LINES_COMBO.translate(String.valueOf(i), String.valueOf(this.removedByAmount[i])), 10, 80 + i * 10, 0x404040);
        }
        this.getModule().drawString(guiGraphics, gui, "W - " + Localization.ARCADE.INSTRUCTION_ROTATE.translate(new String[0]), 340, 20, 0x404040);
        this.getModule().drawString(guiGraphics, gui, "A - " + Localization.ARCADE.INSTRUCTION_LEFT.translate(new String[0]), 340, 30, 0x404040);
        this.getModule().drawString(guiGraphics, gui, "S - " + Localization.ARCADE.INSTRUCTION_DROP.translate(new String[0]), 340, 40, 0x404040);
        this.getModule().drawString(guiGraphics, gui, "D - " + Localization.ARCADE.INSTRUCTION_RIGHT.translate(new String[0]), 340, 50, 0x404040);
        this.getModule().drawString(guiGraphics, gui, "R - " + Localization.ARCADE.INSTRUCTION_RESTART.translate(new String[0]), 340, 70, 0x404040);
    }

    private void newHighScore() {
        if (this.score > this.highscore) {
            int val = this.score / 100;
            byte byte1 = (byte)(val & 0xFF);
            byte byte2 = (byte)((val & 0xFF00) >> 8);
            this.getModule().sendPacket(1, new byte[]{byte1, byte2});
            this.newHighScore = true;
        }
    }

    @Override
    public void receivePacket(int id, byte[] data, Player player) {
        if (id == 1) {
            short data2 = data[0];
            short data3 = data[1];
            if (data2 < 0) {
                data2 = (short)(data2 + 256);
            }
            if (data3 < 0) {
                data3 = (short)(data3 + 256);
            }
            this.highscore = (data2 | data3 << 8) * 100;
        }
    }

    @Override
    public void checkGuiData(Object[] info) {
        this.getModule().updateGuiData(info, TrackStory.stories.size(), (short)(this.highscore / 100));
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == TrackStory.stories.size()) {
            this.highscore = data * 100;
        }
    }

    @Override
    public void Save(CompoundTag tagCompound, int id) {
        tagCompound.putShort(this.getModule().generateNBTName("Highscore", id), (short)this.highscore);
    }

    @Override
    public void Load(CompoundTag tagCompound, int id) {
        this.highscore = tagCompound.getShort(this.getModule().generateNBTName("Highscore", id));
    }

    static {
        texture = "/gui/tetris.png";
    }
}

