/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.entities.EntityMinecartModular;

public class BlockRailJunction
extends BaseRailBlock {
    public static final MapCodec<BlockRailJunction> CODEC = BlockRailJunction.simpleCodec(BlockRailJunction::new);
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.RAIL_SHAPE_STRAIGHT;

    public BlockRailJunction() {
        this(BlockBehaviour.Properties.of().noCollission().strength(0.7f).sound(SoundType.METAL));
    }

    private BlockRailJunction(BlockBehaviour.Properties builder) {
        super(true, builder);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SHAPE, WATERLOGGED});
    }

    @NotNull
    public Property<RailShape> getShapeProperty() {
        return SHAPE;
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    @NotNull
    public RailShape getRailDirection(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @Nullable AbstractMinecart cart) {
        EntityMinecartModular entityMinecartModular;
        RailShape railShape;
        if (cart instanceof EntityMinecartModular && (railShape = (entityMinecartModular = (EntityMinecartModular)cart).getRailDirection(pos)) != null) {
            return railShape;
        }
        return super.getRailDirection(state, world, pos, cart);
    }

    protected MapCodec<? extends BaseRailBlock> codec() {
        return CODEC;
    }
}

