/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.models.workers.tools;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.modules.workers.tools.ModuleFarmer;

public class ModelFarmer
extends ModelCartbase {
    private ModelPart mainAnchor;
    private ModelPart anchor;
    private ModelPart[] outers = new ModelPart[6];

    public ModelFarmer(ResourceLocation resource) {
        super(null, resource);
        this.buildModels();
    }

    public void buildModels() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition mainAnchor = modelPartData.addOrReplaceChild("mainAnchor", CubeListBuilder.create(), PartPose.offset((float)-18.0f, (float)4.0f, (float)0.0f));
        for (int i = -1; i <= 1; i += 2) {
            mainAnchor.addOrReplaceChild("smallArm" + i + i, CubeListBuilder.create().texOffs(26, 23).addBox(-1.0f, -1.0f, -1.0f, 8.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)(i * 17)));
        }
        mainAnchor.addOrReplaceChild("mainArm", CubeListBuilder.create().texOffs(0, 37).addBox(-30.0f, -2.0f, -2.0f, 60.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        for (int j = -1; j <= 1; j += 2) {
            mainAnchor.addOrReplaceChild("extra" + j, CubeListBuilder.create().texOffs(26, 27).addBox(-2.5f, -2.5f, -1.0f, 5.0f, 5.0f, 2.0f), PartPose.offset((float)8.0f, (float)0.0f, (float)(j * 30)));
            mainAnchor.addOrReplaceChild("bigArm" + j, CubeListBuilder.create().texOffs(26, 17).addBox(-1.0f, -2.0f, -1.0f, 16.0f, 4.0f, 2.0f), PartPose.offset((float)8.0f, (float)0.0f, (float)(j * 32)));
        }
        PartDefinition anchor = mainAnchor.addOrReplaceChild("anchor", CubeListBuilder.create(), PartPose.offset((float)22.0f, (float)4.0f, (float)0.0f));
        float start = -1.5f;
        float end = 1.5f;
        for (float k = -1.5f; k <= 1.5f; k += 1.0f) {
            int l;
            for (l = 0; l < 6; ++l) {
                anchor.addOrReplaceChild("side" + k + l, CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -8.8f, -1.0f, 10.0f, 4.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)(k * 20.0f + (float)(l % 2) * 0.005f), (float)0.0f, (float)0.0f, (float)((float)l * ((float)Math.PI * 2) / 6.0f)));
            }
            if (k == start || k == end) {
                anchor.addOrReplaceChild("sidecenter" + k, CubeListBuilder.create().texOffs(0, 12).addBox(-6.0f, -6.0f, -0.5f, 12.0f, 12.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)(k * 20.0f)));
                continue;
            }
            for (l = 0; l < 3; ++l) {
                anchor.addOrReplaceChild("sidecenter2" + k, CubeListBuilder.create().texOffs(26, 12).addBox(-1.0f, -2.0f, -0.5f, 8.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)(k * 20.0f), (float)0.0f, (float)0.0f, (float)(((float)l + 0.25f) * ((float)Math.PI * 2) / 3.0f)));
            }
        }
        for (int m = 0; m < this.outers.length; ++m) {
            PartDefinition middle = anchor.addOrReplaceChild("middle" + m, CubeListBuilder.create().texOffs(0, 6).addBox(-30.0f, -1.7f, -1.0f, 60.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)((float)(m % 2) * 0.005f), (float)((float)m * ((float)Math.PI * 2) / 6.0f), (float)1.5707964f, (float)0.0f));
            PartDefinition nailAnchor = anchor.addOrReplaceChild("nailAnchor" + m, CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)ModelFarmer.nailRot(m), (float)1.5707964f, (float)0.0f));
            PartDefinition outer = nailAnchor.addOrReplaceChild("outer" + m, CubeListBuilder.create().texOffs(0, 10).addBox(-30.0f, -0.5f, -0.5f, 60.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)-8.8f, (float)0.0f, (float)((float)Math.PI), (float)0.0f, (float)0.0f));
            for (int j2 = -13; j2 <= 13; ++j2) {
                if (Math.abs(j2) <= 6 && Math.abs(j2) >= 4) continue;
                outer.addOrReplaceChild("nail" + m + j2, CubeListBuilder.create().texOffs(44, 13).addBox(-0.5f, -1.5f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.offset((float)(j2 * 2), (float)-2.0f, (float)0.0f));
            }
        }
        this.mainAnchor = mainAnchor.bake(64, 64);
        this.anchor = this.mainAnchor.getChild("anchor");
        for (int i = 0; i < this.outers.length; ++i) {
            this.outers[i] = this.anchor.getChild("nailAnchor" + i).getChild("outer" + i);
        }
        this.root = this.mainAnchor;
    }

    @Override
    public void applyEffects(ModuleBase module, PoseStack matrixStack, MultiBufferSource rtb, float yaw, float pitch, float roll) {
        this.mainAnchor.zRot = module == null ? 3.926991f : -((ModuleFarmer)module).getRigAngle();
        float farmAngle = module == null ? 0.0f : ((ModuleFarmer)module).getFarmAngle();
        this.anchor.zRot = -farmAngle;
        for (int i = 0; i < 6; ++i) {
            this.outers[i].xRot = farmAngle + ModelFarmer.nailRot(i);
        }
    }

    private static float nailRot(int i) {
        return ((float)i + 0.5f) * ((float)Math.PI * 2) / 6.0f;
    }

    @Override
    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumers, int light, int overlay, int colour) {
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        super.renderToBuffer(poseStack, vertexConsumers, light, overlay, colour);
        poseStack.popPose();
    }
}

