/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network.packets;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import vswe.stevescarts.entities.EntityMinecartModular;

public class PacketMinecartTurn
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<PacketMinecartTurn> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"stevescarts", (String)"cart_turn"));
    private final int cartID;

    public PacketMinecartTurn(int cartID) {
        this.cartID = cartID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.cartID);
    }

    public static PacketMinecartTurn read(FriendlyByteBuf buffer) {
        return new PacketMinecartTurn(buffer.readInt());
    }

    public static class Handler
    implements IPayloadHandler<PacketMinecartTurn> {
        public void handle(PacketMinecartTurn msg, IPayloadContext ctx) {
            if (ctx.flow() != PacketFlow.SERVERBOUND) {
                return;
            }
            ctx.enqueueWork(() -> {
                Player patt0$temp = ctx.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    Level level = player.level();
                    if (level.getEntity(msg.cartID) == null) {
                        return;
                    }
                    Entity patt1$temp = level.getEntity(msg.cartID);
                    if (patt1$temp instanceof EntityMinecartModular) {
                        EntityMinecartModular entityMinecartModular = (EntityMinecartModular)patt1$temp;
                        entityMinecartModular.turnback();
                    }
                }
            });
        }
    }
}

