/*
 * Decompiled with CFR 0.152.
 */
package mcjty.restrictions.blocks;

import java.util.List;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.restrictions.items.GlassBoots;
import mcjty.restrictions.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class BaseTileEntity
extends TickingTileEntity {
    private AABB aabb = null;
    private final double speed;

    public BaseTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, double speed) {
        super(type, pos, state);
        this.speed = speed;
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            this.powerLevel = (byte)powered;
            this.setChanged();
            BlockState state = this.level.getBlockState(this.getBlockPos());
            this.level.sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }

    protected AABB getBox() {
        if (this.aabb == null) {
            assert (this.level != null);
            Direction direction = (Direction)this.level.getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.FACING);
            this.aabb = new AABB(this.getBlockPos().relative(direction));
            if (this.powerLevel > 1) {
                this.aabb = this.aabb.minmax(new AABB(this.getBlockPos().relative(direction, (int)this.powerLevel)));
            }
        }
        return this.aabb;
    }

    public void loadClientDataFromNBT(CompoundTag tag, HolderLookup.Provider provider) {
        this.powerLevel = tag.getByte("powered");
    }

    public void saveClientDataToNBT(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putByte("powered", this.powerLevel);
    }

    protected void tickServer() {
        assert (this.level != null);
        Direction direction = (Direction)this.level.getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.FACING);
        if (this.powerLevel > 0) {
            List entities = this.level.getEntitiesOfClass(Entity.class, this.getBox());
            for (Entity entity : entities) {
                entity.push((double)direction.getStepX() * this.speed, (double)direction.getStepY() * this.speed, (double)direction.getStepZ() * this.speed);
                if (direction != Direction.UP || !(entity.getDeltaMovement().y > -0.5)) continue;
                entity.fallDistance = 1.0f;
            }
        }
    }

    protected void tickClient() {
        BlockState state;
        if (this.powerLevel > 0 && ((state = this.level.getBlockState(this.getBlockPos())).getBlock() == Registration.ATTRACTOR.get() || state.getBlock() == Registration.PUSHER.get())) {
            Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            List entities = this.level.getEntitiesOfClass(Player.class, this.getBox());
            for (Player entity : entities) {
                ItemStack boots = entity.getItemBySlot(EquipmentSlot.FEET);
                if (!boots.isEmpty() && boots.getItem() instanceof GlassBoots) continue;
                entity.push((double)direction.getStepX() * this.speed, (double)direction.getStepY() * this.speed, (double)direction.getStepZ() * this.speed);
                if (direction != Direction.UP || !(entity.getDeltaMovement().y > -0.5)) continue;
                entity.fallDistance = 1.0f;
            }
        }
    }
}

