/*
 * Decompiled with CFR 0.152.
 */
package com.memorysettings;

import com.memorysettings.Memory;
import com.memorysettings.config.CommonConfiguration;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;

@Mod(value="memorysettings")
public class MemorysettingsMod {
    public static final String MODID = "memorysettings";
    private static final String DISABLE_WARNING_BUTTON = "Stop showing";
    public static Random rand = new Random();
    public static MutableComponent memorycheckresult = Component.empty();
    public static boolean didDisplay = false;

    public MemorysettingsMod(IEventBus modEventBus, ModContainer modContainer) {
        if (!((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).disableWarnings) {
            Memory.doEarlyWarnings();
            MemorysettingsMod.doWarning();
        }
    }

    public static void doWarning() {
        int configMax = FMLEnvironment.dist != Dist.DEDICATED_SERVER ? ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).maximumClient : ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).maximumServer;
        int configMin = FMLEnvironment.dist != Dist.DEDICATED_SERVER ? ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumClient : ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumServer;
        int recommendMemory = Math.min(Memory.getRecommendedMemoryForSystemMemory(Memory.systemMemory), configMax);
        Object message = "";
        if (Memory.heapSetting > configMax + 250) {
            message = (String)message + "You have more memory allocated(" + Memory.heapSetting + "mb) than recommended for this pack, the maximum is: " + configMax + "mb.\nThe recommended amount for your system is: " + recommendMemory + " mb.\n";
            memorycheckresult.append((Component)Component.translatable((String)"warning.toomuch", (Object[])new Object[]{Component.literal((String)("" + Memory.heapSetting)).withStyle(ChatFormatting.YELLOW), Component.literal((String)("" + configMax)).withStyle(ChatFormatting.BLUE), Component.literal((String)("" + recommendMemory)).withStyle(ChatFormatting.GREEN)}));
        }
        if (Memory.heapSetting < configMin - 250) {
            message = (String)message + "You have less memory allocated(" + Memory.heapSetting + "mb) than recommended for this pack, the minimum is: " + configMin + "mb.\nThe recommended amount for your system is: " + recommendMemory + " mb.\n";
            memorycheckresult.append((Component)Component.translatable((String)"warning.toolow", (Object[])new Object[]{Component.literal((String)("" + Memory.heapSetting)).withStyle(ChatFormatting.YELLOW), Component.literal((String)("" + configMin)).withStyle(ChatFormatting.BLUE), Component.literal((String)("" + recommendMemory)).withStyle(ChatFormatting.GREEN)}));
        }
        if ((double)Math.abs(Memory.heapSetting - recommendMemory) / (double)recommendMemory * 100.0 > (double)((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).warningTolerance && Memory.heapSetting <= configMax && Memory.heapSetting >= configMin) {
            message = (String)message + "You have " + (Memory.heapSetting > recommendMemory ? "more" : "less") + " more memory allocated than recommended for your system, the recommended amount for your system is: " + recommendMemory + " mb.\n";
            memorycheckresult.append((Component)Component.translatable((String)(Memory.heapSetting > recommendMemory ? "warning.overrecommended" : "warning.underrecommended"), (Object[])new Object[]{Component.literal((String)("" + Memory.heapSetting)).withStyle(ChatFormatting.YELLOW), Component.literal((String)("" + recommendMemory)).withStyle(ChatFormatting.GREEN)}));
        }
        if (recommendMemory < configMin - 250) {
            message = (String)message + "The recommended for your system is lower than the required minimum of " + configMin + "mb for this pack, things may not work out so well.\nMost common sign of insufficient ram is frequent stutters.\n";
            memorycheckresult.append((Component)Component.translatable((String)"warning.recommendedbelowmin", (Object[])new Object[]{Component.literal((String)("" + recommendMemory)).withStyle(ChatFormatting.GREEN), Component.literal((String)("" + configMin)).withStyle(ChatFormatting.RED)}));
        }
        if (((String)message).equals("")) {
            return;
        }
        CommonConfiguration.LOGGER.warn((String)message);
    }
}

