/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackAccessLogger;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.command.BackpackUUIDArgumentType;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;

public class GiveCommand {
    private GiveCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"give").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"backpackUuid", (ArgumentType)BackpackUUIDArgumentType.backpackUuid()).executes(context -> GiveCommand.giveBackpack((CommandSourceStack)context.getSource(), (UUID)context.getArgument("backpackUuid", UUID.class), EntityArgument.getPlayers((CommandContext)context, (String)"targets")))));
    }

    private static int giveBackpack(CommandSourceStack source, UUID backpackUuid, Collection<ServerPlayer> players) {
        BackpackAccessLogger.getBackpackLog(backpackUuid).ifPresent(alr -> {
            Item item = (Item)BuiltInRegistries.ITEM.get(alr.getBackpackItemRegistryName());
            ItemStack backpack = new ItemStack((ItemLike)item);
            if (!backpack.getHoverName().getString().equals(alr.getBackpackName())) {
                backpack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)alr.getBackpackName()));
            }
            IBackpackWrapper backpackWrapper = BackpackWrapper.fromStack(backpack);
            backpackWrapper.setColors(alr.getClothColor(), alr.getTrimColor());
            backpackWrapper.setColumnsTaken(alr.getColumnsTaken(), false);
            backpackWrapper.setContentsUuid(backpackUuid);
            players.forEach(p -> GiveCommand.giveBackpackToPlayer(backpack, p));
            if (players.size() == 1) {
                source.sendSuccess(() -> Component.translatable((String)"commands.sophisticatedbackpacks.give.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).getDisplayName()}), true);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"commands.sophisticatedbackpacks.give.success", (Object[])new Object[]{players.size()}), true);
            }
        });
        return 0;
    }

    private static void giveBackpackToPlayer(ItemStack backpack, ServerPlayer p) {
        ItemEntity itemEntity;
        boolean flag = p.getInventory().add(backpack);
        if (flag && backpack.isEmpty()) {
            backpack.setCount(1);
            itemEntity = p.drop(backpack, false);
            if (itemEntity != null) {
                itemEntity.makeFakeItem();
            }
            p.level().playSound(null, p.getX(), p.getY(), p.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (RandHelper.getRandomMinusOneToOne((RandomSource)p.getRandom()) * 0.7f + 1.0f) * 2.0f);
            p.inventoryMenu.broadcastChanges();
        } else {
            ItemEntity itementity = p.drop(backpack, false);
            if (itementity != null) {
                itementity.setNoPickUpDelay();
                itementity.setThrower((Entity)p);
            }
        }
        itemEntity = p.drop(backpack, false);
        if (itemEntity != null) {
            itemEntity.makeFakeItem();
        }
    }
}

