/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.meklm.common.tile.prefab;

import com.jerry.meklm.common.tile.prefab.TileEntityConfigurableLargeMachine;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BooleanSupplier;
import mekanism.api.IContentsListener;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.monitor.RecipeCacheLookupMonitor;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityRecipeLargeMachine<RECIPE extends MekanismRecipe<?>>
extends TileEntityConfigurableLargeMachine
implements IRecipeLookupHandler<RECIPE> {
    public static final int RECIPE_CHECK_FREQUENCY = 100;
    protected final BooleanSupplier recheckAllRecipeErrors;
    private final List<CachedRecipe.OperationTracker.RecipeError> errorTypes;
    private final boolean[] trackedErrors;
    protected RecipeCacheLookupMonitor<RECIPE> recipeCacheLookupMonitor;
    @Nullable
    private IContentsListener recipeCacheSaveOnlyListener;
    @Nullable
    private IContentsListener recipeCacheUnpauseListener;
    @Nullable
    private IContentsListener recipeCacheUnpauseSaveOnlyListener;

    protected TileEntityRecipeLargeMachine(Holder<Block> blockProvider, BlockPos pos, BlockState state, List<CachedRecipe.OperationTracker.RecipeError> errorTypes) {
        super(blockProvider, pos, state);
        this.errorTypes = List.copyOf(errorTypes);
        this.recheckAllRecipeErrors = TileEntityRecipeLargeMachine.shouldRecheckAllErrors(this);
        this.trackedErrors = new boolean[this.errorTypes.size()];
        this.recipeCacheSaveOnlyListener = null;
        this.recipeCacheUnpauseListener = null;
        this.recipeCacheUnpauseSaveOnlyListener = null;
    }

    protected void presetVariables() {
        super.presetVariables();
        this.recipeCacheLookupMonitor = this.createNewCacheMonitor();
    }

    protected RecipeCacheLookupMonitor<RECIPE> createNewCacheMonitor() {
        return new RecipeCacheLookupMonitor((IRecipeLookupHandler)this);
    }

    protected IContentsListener getRecipeCacheSaveOnlyListener() {
        if (this.supportsComparator()) {
            if (this.recipeCacheSaveOnlyListener == null) {
                this.recipeCacheSaveOnlyListener = () -> {
                    this.markForSave();
                    this.recipeCacheLookupMonitor.onChange();
                };
            }
            return this.recipeCacheSaveOnlyListener;
        }
        return this.recipeCacheLookupMonitor;
    }

    protected IContentsListener getRecipeCacheUnpauseListener(@Nullable IContentsListener listener) {
        if (listener == this) {
            if (this.recipeCacheUnpauseListener == null) {
                this.recipeCacheUnpauseListener = () -> {
                    this.onContentsChanged();
                    this.recipeCacheLookupMonitor.unpause();
                };
            }
            return this.recipeCacheUnpauseListener;
        }
        if (this.recipeCacheUnpauseSaveOnlyListener == null) {
            this.recipeCacheUnpauseSaveOnlyListener = () -> {
                this.markForSave();
                this.recipeCacheLookupMonitor.unpause();
            };
        }
        return this.recipeCacheUnpauseSaveOnlyListener;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.trackArray(this.trackedErrors);
    }

    public void clearRecipeErrors(int cacheIndex) {
        Arrays.fill(this.trackedErrors, false);
    }

    protected void onErrorsChanged(Set<CachedRecipe.OperationTracker.RecipeError> errors) {
        for (int i = 0; i < this.trackedErrors.length; ++i) {
            this.trackedErrors[i] = errors.contains(this.errorTypes.get(i));
        }
    }

    public BooleanSupplier getWarningCheck(CachedRecipe.OperationTracker.RecipeError error) {
        int errorIndex = this.errorTypes.indexOf(error);
        if (errorIndex == -1) {
            return () -> false;
        }
        return () -> this.trackedErrors[errorIndex];
    }

    public static BooleanSupplier shouldRecheckAllErrors(TileEntityMekanism tile) {
        int checkOffset = ThreadLocalRandom.current().nextInt(100);
        return () -> !tile.playersUsing.isEmpty() && tile.hasLevel() && tile.getLevel().getGameTime() % 100L == (long)checkOffset;
    }

    @Nullable
    public final IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        return this.getInitialChemicalTanks(listener, listener == this ? this.recipeCacheLookupMonitor : this.getRecipeCacheSaveOnlyListener(), this.getRecipeCacheUnpauseListener(listener));
    }

    @Nullable
    protected IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        return null;
    }

    @Nullable
    protected final IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        return this.getInitialFluidTanks(listener, listener == this ? this.recipeCacheLookupMonitor : this.getRecipeCacheSaveOnlyListener(), this.getRecipeCacheUnpauseListener(listener));
    }

    @Nullable
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        return null;
    }

    @Nullable
    protected final IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        return this.getInitialEnergyContainers(listener, listener == this ? this.recipeCacheLookupMonitor : this.getRecipeCacheSaveOnlyListener(), this.getRecipeCacheUnpauseListener(listener));
    }

    @Nullable
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        return null;
    }

    @Nullable
    protected final IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        return this.getInitialInventory(listener, listener == this ? this.recipeCacheLookupMonitor : this.getRecipeCacheSaveOnlyListener(), this.getRecipeCacheUnpauseListener(listener));
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        return null;
    }

    @Nullable
    protected final IHeatCapacitorHolder getInitialHeatCapacitors(IContentsListener listener, CachedAmbientTemperature ambientTemperature) {
        return this.getInitialHeatCapacitors(listener, listener == this ? this.recipeCacheLookupMonitor : this.getRecipeCacheSaveOnlyListener(), this.getRecipeCacheUnpauseListener(listener), ambientTemperature);
    }

    @Nullable
    protected IHeatCapacitorHolder getInitialHeatCapacitors(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener, CachedAmbientTemperature ambientTemperature) {
        return null;
    }
}

