/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.recipe_viewer.jei;

import com.jerry.mekmm.common.block.attribute.MMAttributeFactoryType;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import java.util.List;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.tier.FactoryTier;
import mekanism.common.util.EnumUtils;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class MMCatalystRegistryHelper {
    private MMCatalystRegistryHelper() {
    }

    public static void register(IRecipeCatalystRegistration registry, boolean needOrdinary, IRecipeViewerRecipeType<?> ... categories) {
        for (IRecipeViewerRecipeType<?> category : categories) {
            MMCatalystRegistryHelper.register(registry, MekanismJEI.genericRecipeType(category), category.workstations(), needOrdinary);
        }
    }

    public static void register(IRecipeCatalystRegistration registry, RecipeType<?> recipeType, List<ItemLike> workstations, boolean needOrdinary) {
        for (ItemLike workstation : workstations) {
            BlockItem blockItem;
            MMAttributeFactoryType factoryType;
            Item item = workstation.asItem();
            if (needOrdinary) {
                registry.addRecipeCatalyst((ItemLike)item, new RecipeType[]{recipeType});
            }
            if (!(item instanceof BlockItem) || (factoryType = (MMAttributeFactoryType)Attribute.get((Block)(blockItem = (BlockItem)item).getBlock(), MMAttributeFactoryType.class)) == null) continue;
            for (FactoryTier tier : EnumUtils.FACTORY_TIERS) {
                registry.addRecipeCatalyst(MoreMachineBlocks.getMMFactory(tier, factoryType.getMMFactoryType()), new RecipeType[]{recipeType});
            }
        }
    }
}

