/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.content.blocktype;

import com.jerry.mekmm.common.block.attribute.MMAttributeFactoryType;
import com.jerry.mekmm.common.content.blocktype.MoreMachineBlockShapes;
import com.jerry.mekmm.common.content.blocktype.MoreMachineFactoryType;
import com.jerry.mekmm.common.content.blocktype.MoreMachineMachine;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import com.jerry.mekmm.common.registries.MoreMachineContainerTypes;
import com.jerry.mekmm.common.tile.factory.TileEntityMoreMachineFactory;
import java.util.function.Supplier;
import mekanism.api.math.MathUtils;
import mekanism.api.text.ILangEntry;
import mekanism.api.tier.ITier;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.block.attribute.AttributeParticleFX;
import mekanism.common.block.attribute.AttributeSideConfig;
import mekanism.common.block.attribute.AttributeSound;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.AttributeUpgradeable;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tier.FactoryTier;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;

public class MoreMachineFactory<TILE extends TileEntityMoreMachineFactory<?>>
extends MoreMachineMachine.MoreMachineFactoryMachine<TILE> {
    private final MoreMachineMachine.MoreMachineFactoryMachine<?> origMachine;

    public MoreMachineFactory(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, Supplier<ContainerTypeRegistryObject<? extends MekanismContainer>> containerRegistrar, MoreMachineMachine.MoreMachineFactoryMachine<?> origMachine, FactoryTier tier) {
        super(tileEntityRegistrar, (ILangEntry)MekanismLang.DESCRIPTION_FACTORY, origMachine.getMMFactoryType());
        this.origMachine = origMachine;
        this.setMachineData(tier);
        this.add(new Attribute[]{new AttributeGui(containerRegistrar, null), new AttributeTier((ITier)tier)});
        if (tier.ordinal() < EnumUtils.FACTORY_TIERS.length - 1) {
            this.add(new Attribute[]{new AttributeUpgradeable(() -> MoreMachineBlocks.getMMFactory(EnumUtils.FACTORY_TIERS[tier.ordinal() + 1], origMachine.getMMFactoryType()))});
        }
    }

    private void setMachineData(FactoryTier tier) {
        this.setFrom(this.origMachine, new Class[]{AttributeSound.class, MMAttributeFactoryType.class, AttributeUpgradeSupport.class});
        AttributeEnergy origEnergy = (AttributeEnergy)this.origMachine.get(AttributeEnergy.class);
        Attribute[] attributeArray = new Attribute[1];
        attributeArray[0] = new AttributeEnergy(() -> ((AttributeEnergy)origEnergy).getUsage(), () -> MathUtils.clampToLong((double)(Math.max((double)origEnergy.getConfigStorage() * 0.5, (double)origEnergy.getUsage()) * (double)tier.processes)));
        this.add(attributeArray);
    }

    public static class MMFactoryBuilder<FACTORY extends MoreMachineFactory<TILE>, TILE extends TileEntityMoreMachineFactory<?>, T extends MoreMachineMachine.MMMachineBuilder<FACTORY, TILE, T>>
    extends BlockTypeTile.BlockTileBuilder<FACTORY, TILE, T> {
        protected MMFactoryBuilder(FACTORY holder) {
            super(holder);
        }

        public static <TILE extends TileEntityMoreMachineFactory<?>> MMFactoryBuilder<MoreMachineFactory<TILE>, TILE, ?> createMMFactory(Supplier<?> tileEntityRegistrar, MoreMachineFactoryType type, FactoryTier tier) {
            MMFactoryBuilder builder = new MMFactoryBuilder(new MoreMachineFactory(tileEntityRegistrar, () -> MoreMachineContainerTypes.MM_FACTORY, type.getBaseMachine(), tier));
            builder.withComputerSupport((ITier)tier, type.getRegistryNameComponentCapitalized() + "Factory");
            builder.withCustomShape(MoreMachineBlockShapes.getShape(tier, type));
            Attribute[] attributeArray = new Attribute[1];
            attributeArray[0] = switch (type) {
                default -> throw new MatchException(null, null);
                case MoreMachineFactoryType.RECYCLING, MoreMachineFactoryType.CNC_STAMPING, MoreMachineFactoryType.CNC_LATHING, MoreMachineFactoryType.CNC_ROLLING_MILL -> AttributeSideConfig.ELECTRIC_MACHINE;
                case MoreMachineFactoryType.PLANTING_STATION, MoreMachineFactoryType.REPLICATING -> AttributeSideConfig.ADVANCED_ELECTRIC_MACHINE;
            };
            builder.with(attributeArray);
            builder.replace(new Attribute[]{new AttributeParticleFX().addDense((ParticleOptions)ParticleTypes.SMOKE, 5, rand -> new Pos3D((double)(rand.nextFloat() * 0.7f - 0.3f), (double)(rand.nextFloat() * 0.1f + 0.7f), (double)(rand.nextFloat() * 0.7f - 0.3f)))});
            return builder;
        }
    }
}

