/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekmm.common.tile.interfaces.ITileConnect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.energy.BlockEnergyCapabilityCache;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityWirelessTransmissionStation
extends TileEntityConfigurableMachine
implements ITileConnect {
    public Map<BlockPos, Table<Direction, TransmissionType, BlockCapabilityCache<IStrictEnergyHandler, @Nullable Direction>>> energyCapabilityCache;
    public Map<BlockPos, Table<Direction, TransmissionType, BlockCapabilityCache<IFluidHandler, @Nullable Direction>>> fluidCapabilityCache;
    public Map<BlockPos, Table<Direction, TransmissionType, BlockCapabilityCache<IChemicalHandler, @Nullable Direction>>> chemicalCapabilityCache;
    public Map<BlockPos, Table<Direction, TransmissionType, BlockCapabilityCache<IItemHandler, @Nullable Direction>>> itemCapabilityCache;
    private Table<Direction, BlockPos, BlockCapabilityCache<IHeatHandler, @Nullable Direction>> heatCapabilityCaches = HashBasedTable.create();
    public static final long MAX_CHEMICAL = 10000L;
    public static final int MAX_FLUID = 10000;
    public BasicFluidTank fluidTank;
    public IChemicalTank chemicalTank;
    public BasicInventorySlot inventorySlot;
    public MachineEnergyContainer<TileEntityWirelessTransmissionStation> energyContainer;
    public BasicHeatCapacitor heatCapacitor;

    public TileEntityWirelessTransmissionStation(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.configComponent.setupIOConfig(TransmissionType.ENERGY, this.energyContainer, RelativeSide.FRONT);
        this.configComponent.setupIOConfig(TransmissionType.FLUID, (Object)this.fluidTank, RelativeSide.LEFT);
        this.configComponent.setupIOConfig(TransmissionType.CHEMICAL, (Object)this.chemicalTank, RelativeSide.RIGHT);
        this.configComponent.setupIOConfig(TransmissionType.ITEM, (Object)this.inventorySlot, RelativeSide.BOTTOM, true);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.CHEMICAL, TransmissionType.FLUID, TransmissionType.ENERGY});
        this.energyCapabilityCache = new ConcurrentHashMap<BlockPos, Table<Direction, TransmissionType, BlockCapabilityCache<IStrictEnergyHandler, Direction>>>();
        this.fluidCapabilityCache = new ConcurrentHashMap<BlockPos, Table<Direction, TransmissionType, BlockCapabilityCache<IFluidHandler, Direction>>>();
        this.chemicalCapabilityCache = new ConcurrentHashMap<BlockPos, Table<Direction, TransmissionType, BlockCapabilityCache<IChemicalHandler, Direction>>>();
        this.itemCapabilityCache = new ConcurrentHashMap<BlockPos, Table<Direction, TransmissionType, BlockCapabilityCache<IItemHandler, Direction>>>();
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig((ISideConfiguration)this);
        this.inventorySlot = BasicInventorySlot.at((IContentsListener)listener, (int)40, (int)10);
        builder.addSlot((IInventorySlot)this.inventorySlot);
        return builder.build();
    }

    @Nullable
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideWithConfig((ISideConfiguration)this);
        this.chemicalTank = BasicChemicalTank.createModern((long)10000L, (Predicate)ConstantPredicates.alwaysTrue(), (Predicate)ConstantPredicates.alwaysTrue(), (IContentsListener)listener);
        builder.addTank(this.chemicalTank);
        return builder.build();
    }

    @Nullable
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSideWithConfig((ISideConfiguration)this);
        this.fluidTank = BasicFluidTank.create((int)10000, (IContentsListener)listener);
        builder.addTank((IExtendedFluidTank)this.fluidTank);
        return builder.build();
    }

    @Nullable
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig((ISideConfiguration)this);
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.getEnergyCapabilityCache();
        FluidUtils.emit(this.getFluidCapabilityCache(), (IExtendedFluidTank)this.fluidTank, (int)1);
        ChemicalUtil.emit(this.getChemicalCapabilityCache(), (IChemicalTank)this.chemicalTank, (long)1L);
        this.getItemCapabilityCache();
        return sendUpdatePacket;
    }

    public Collection<BlockCapabilityCache<IStrictEnergyHandler, @Nullable Direction>> getEnergyCapabilityCache() {
        ArrayList<BlockCapabilityCache<IStrictEnergyHandler, @Nullable Direction>> energyCapCache = new ArrayList<BlockCapabilityCache<IStrictEnergyHandler, Direction>>(Collections.emptyList());
        if (this.energyCapabilityCache != null) {
            for (Map.Entry<BlockPos, Table<Direction, TransmissionType, BlockCapabilityCache<IStrictEnergyHandler, Direction>>> entry : this.energyCapabilityCache.entrySet()) {
                for (Direction direction : Direction.values()) {
                    BlockCapabilityCache cap;
                    if (entry.getValue() == null || (cap = (BlockCapabilityCache)entry.getValue().get((Object)direction, (Object)TransmissionType.ENERGY)) == null) continue;
                    energyCapCache.add((BlockCapabilityCache<IStrictEnergyHandler, Direction>)cap);
                    BlockEnergyCapabilityCache.create((ServerLevel)((ServerLevel)this.level), (BlockPos)entry.getKey(), (Direction)direction);
                }
            }
        }
        return energyCapCache;
    }

    public Collection<BlockCapabilityCache<IFluidHandler, @Nullable Direction>> getFluidCapabilityCache() {
        ArrayList<BlockCapabilityCache<IFluidHandler, @Nullable Direction>> fluidCapCache = new ArrayList<BlockCapabilityCache<IFluidHandler, Direction>>(Collections.emptyList());
        if (this.fluidCapabilityCache != null) {
            for (Map.Entry<BlockPos, Table<Direction, TransmissionType, BlockCapabilityCache<IFluidHandler, Direction>>> entry : this.fluidCapabilityCache.entrySet()) {
                for (Direction direction : Direction.values()) {
                    BlockCapabilityCache cap;
                    if (entry.getValue() == null || (cap = (BlockCapabilityCache)entry.getValue().get((Object)direction, (Object)TransmissionType.FLUID)) == null) continue;
                    fluidCapCache.add((BlockCapabilityCache<IFluidHandler, Direction>)cap);
                }
            }
        }
        return fluidCapCache;
    }

    public Collection<BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> getChemicalCapabilityCache() {
        ArrayList<BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> chemicalCapCache = new ArrayList<BlockCapabilityCache<IChemicalHandler, Direction>>(Collections.emptyList());
        if (this.chemicalCapabilityCache != null) {
            for (Map.Entry<BlockPos, Table<Direction, TransmissionType, BlockCapabilityCache<IChemicalHandler, Direction>>> entry : this.chemicalCapabilityCache.entrySet()) {
                for (Direction direction : Direction.values()) {
                    BlockCapabilityCache cap;
                    if (entry.getValue() == null || (cap = (BlockCapabilityCache)entry.getValue().get((Object)direction, (Object)TransmissionType.CHEMICAL)) == null) continue;
                    chemicalCapCache.add((BlockCapabilityCache<IChemicalHandler, Direction>)cap);
                }
            }
        }
        return chemicalCapCache;
    }

    public void getItemCapabilityCache() {
        if (this.itemCapabilityCache != null) {
            for (Map.Entry<BlockPos, Table<Direction, TransmissionType, BlockCapabilityCache<IItemHandler, Direction>>> entry : this.itemCapabilityCache.entrySet()) {
                for (Direction direction : Direction.values()) {
                    BlockCapabilityCache cap;
                    if (entry.getValue() == null || (cap = (BlockCapabilityCache)entry.getValue().get((Object)direction, (Object)TransmissionType.ITEM)) == null) continue;
                    TransitRequest.anyItem((IItemHandler)((IItemHandler)cap.getCapability()), (int)1);
                }
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public ConnectStatus connectOrCut(BlockPos blockPos, Direction direction, TransmissionType type) {
        if (blockPos != null && direction != null && type != null) {
            switch (type) {
                case ENERGY: {
                    @Nullable Table energyTables = this.energyCapabilityCache.computeIfAbsent(blockPos, pos -> HashBasedTable.create());
                    if (energyTables.contains((Object)direction, (Object)type)) {
                        energyTables.remove((Object)direction, (Object)type);
                        return ConnectStatus.DISCONNECT;
                    }
                    if (WorldUtils.getCapability((Level)this.getLevel(), (BlockCapability)Capabilities.STRICT_ENERGY.block(), (BlockPos)blockPos, (Object)direction) != null) {
                        energyTables.put((Object)direction, (Object)type, (Object)Capabilities.STRICT_ENERGY.createCache((ServerLevel)this.level, blockPos, direction));
                        this.energyCapabilityCache.put(blockPos, (Table<Direction, TransmissionType, BlockCapabilityCache<IStrictEnergyHandler, Direction>>)energyTables);
                        return ConnectStatus.CONNECT;
                    }
                    return ConnectStatus.CONNECT_FAIL;
                }
                case FLUID: {
                    @Nullable Table fluidTables = this.fluidCapabilityCache.computeIfAbsent(blockPos, pos -> HashBasedTable.create());
                    if (fluidTables.contains((Object)direction, (Object)type)) {
                        fluidTables.remove((Object)direction, (Object)type);
                        return ConnectStatus.DISCONNECT;
                    }
                    if (WorldUtils.getCapability((Level)this.getLevel(), (BlockCapability)Capabilities.FLUID.block(), (BlockPos)blockPos, (Object)direction) != null) {
                        fluidTables.put((Object)direction, (Object)type, (Object)Capabilities.FLUID.createCache((ServerLevel)this.level, blockPos, direction));
                        this.fluidCapabilityCache.put(blockPos, (Table<Direction, TransmissionType, BlockCapabilityCache<IFluidHandler, Direction>>)fluidTables);
                        return ConnectStatus.CONNECT;
                    }
                    return ConnectStatus.CONNECT_FAIL;
                }
                case CHEMICAL: {
                    @Nullable Table chemicalTables = this.chemicalCapabilityCache.computeIfAbsent(blockPos, pos -> HashBasedTable.create());
                    if (chemicalTables.contains((Object)direction, (Object)type)) {
                        chemicalTables.remove((Object)direction, (Object)type);
                        return ConnectStatus.DISCONNECT;
                    }
                    if (WorldUtils.getCapability((Level)this.getLevel(), (BlockCapability)Capabilities.CHEMICAL.block(), (BlockPos)blockPos, (Object)direction) != null) {
                        chemicalTables.put((Object)direction, (Object)type, (Object)Capabilities.CHEMICAL.createCache((ServerLevel)this.level, blockPos, direction));
                        this.chemicalCapabilityCache.put(blockPos, (Table<Direction, TransmissionType, BlockCapabilityCache<IChemicalHandler, Direction>>)chemicalTables);
                        return ConnectStatus.CONNECT;
                    }
                    return ConnectStatus.CONNECT_FAIL;
                }
                case ITEM: {
                    @Nullable Table itemTables = this.itemCapabilityCache.computeIfAbsent(blockPos, pos -> HashBasedTable.create());
                    if (itemTables.contains((Object)direction, (Object)type)) {
                        itemTables.remove((Object)direction, (Object)type);
                        return ConnectStatus.DISCONNECT;
                    }
                    if (WorldUtils.getCapability((Level)this.getLevel(), (BlockCapability)Capabilities.ITEM.block(), (BlockPos)blockPos, (Object)direction) != null) {
                        itemTables.put((Object)direction, (Object)type, (Object)Capabilities.ITEM.createCache((ServerLevel)this.level, blockPos, direction));
                        this.itemCapabilityCache.put(blockPos, (Table<Direction, TransmissionType, BlockCapabilityCache<IItemHandler, Direction>>)itemTables);
                        return ConnectStatus.CONNECT;
                    }
                    return ConnectStatus.CONNECT_FAIL;
                }
            }
        }
        return ConnectStatus.CONNECT_FAIL;
    }

    @Nullable
    public MachineEnergyContainer<TileEntityWirelessTransmissionStation> getEnergyContainer() {
        return this.energyContainer;
    }

    public Map<BlockPos, Table<Direction, TransmissionType, BlockCapabilityCache<IChemicalHandler, @Nullable Direction>>> getCap() {
        return this.chemicalCapabilityCache;
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
    }

    public void saveAdditional(@NotNull CompoundTag nbtTags, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
    }

    public static enum ConnectStatus {
        CONNECT,
        DISCONNECT,
        CONNECT_FAIL;

    }
}

