/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.pricklemc.common.api.config.comment;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.LinkedList;
import net.darkhax.pricklemc.common.api.annotations.Value;
import net.darkhax.pricklemc.common.api.config.comment.Comment;
import net.darkhax.pricklemc.common.api.config.comment.ICommentResolver;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class WrappedComment
extends Comment {
    public static final ICommentResolver RESOLVER = new WrappedCommentResolver(80, true);

    public WrappedComment(String text, int lineLength, boolean pad) {
        super(WrappedComment.wrap(text, lineLength, pad));
    }

    private static String[] wrap(String text, int lineLength, boolean pad) {
        if (text.length() <= lineLength) {
            return new String[]{text};
        }
        LinkedList<String> lines = new LinkedList<String>();
        String[] words = text.split("\\s+");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() <= lineLength) {
                currentLine.append(word);
                if (currentLine.length() == lineLength) continue;
                currentLine.append(" ");
                continue;
            }
            lines.add(pad ? StringUtils.rightPad((String)currentLine.toString(), (int)lineLength) : currentLine.toString().trim());
            currentLine = new StringBuilder(word + " ");
        }
        if (!currentLine.isEmpty()) {
            lines.add(pad ? StringUtils.rightPad((String)currentLine.toString(), (int)lineLength) : currentLine.toString().trim());
        }
        return (String[])lines.toArray(String[]::new);
    }

    public static class WrappedCommentResolver
    implements ICommentResolver {
        private final int lineLength;
        private final boolean padLength;

        public WrappedCommentResolver(int lineLength, boolean padLength) {
            this.lineLength = lineLength;
            this.padLength = padLength;
        }

        @Override
        @Nullable
        public WrappedComment resolve(Field field, @Nullable Object value, Value valueMeta) throws IOException {
            return ICommentResolver.hasComment(valueMeta) ? new WrappedComment(valueMeta.comment(), this.lineLength, this.padLength) : null;
        }
    }
}

