/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.omegaconfig.api;

import io.github.frqnny.omegaconfig.OmegaConfig;
import io.github.frqnny.omegaconfig.api.Syncing;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public interface Config {
    default public void save() {
        OmegaConfig.writeConfig(this.getClass(), this);
    }

    default public CompoundTag writeSyncingTag() {
        CompoundTag tag = new CompoundTag();
        tag.putString("ConfigName", this.getName());
        if (Arrays.stream(this.getClass().getAnnotations()).anyMatch(annotation -> annotation instanceof Syncing)) {
            String json = OmegaConfig.GSON.toJson((Object)this);
            tag.putString("Serialized", json);
            tag.putBoolean("AllSync", true);
        } else {
            String json = OmegaConfig.SYNC_ONLY_GSON.toJson((Object)this);
            tag.putString("Serialized", json);
            tag.putBoolean("AllSync", false);
        }
        return tag;
    }

    default public boolean hasAnySyncable() {
        boolean hasSyncingField = Arrays.stream(this.getClass().getDeclaredFields()).anyMatch(field -> Arrays.stream(field.getDeclaredAnnotations()).anyMatch(annotation -> annotation instanceof Syncing));
        boolean classSyncs = Arrays.stream(this.getClass().getDeclaredAnnotations()).anyMatch(annotation -> annotation instanceof Syncing);
        return hasSyncingField | classSyncs;
    }

    public String getName();

    @Nullable
    default public String getModid() {
        return null;
    }

    default public String getExtension() {
        return "json";
    }

    default public String getDirectory() {
        return "";
    }
}

