/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.omegaconfig.mixin;

import dev.architectury.networking.NetworkManager;
import io.github.frqnny.omegaconfig.OmegaConfig;
import io.github.frqnny.omegaconfig.api.Config;
import io.github.frqnny.omegaconfig.api.Syncing;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.main.GameConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class ClientMixin {
    @Unique
    private final List<Config> savedClientConfig = new ArrayList<Config>();

    @Inject(method={"<init>(Lnet/minecraft/client/main/GameConfig;)V"}, at={@At(value="RETURN")})
    private void onReturn(GameConfig args, CallbackInfo ci) {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, OmegaConfig.SyncConfigPayload.ID, OmegaConfig.SyncConfigPayload.CODEC, (payload, context) -> {
            CompoundTag tag = payload.nbtCompound();
            this.savedClientConfig.clear();
            Minecraft.getInstance().execute(() -> {
                if (tag != null && tag.contains("Configurations")) {
                    ListTag list = tag.getList("Configurations", 10);
                    list.forEach(compound -> {
                        CompoundTag syncedConfiguration = (CompoundTag)compound;
                        String name = syncedConfiguration.getString("ConfigName");
                        String json = syncedConfiguration.getString("Serialized");
                        boolean allSync = syncedConfiguration.getBoolean("AllSync");
                        for (Config config : OmegaConfig.getRegisteredConfigurations()) {
                            if (!config.getName().equals(name)) continue;
                            Config server = (Config)OmegaConfig.GSON.fromJson(json, config.getClass());
                            Config cachedClient = (Config)OmegaConfig.GSON.fromJson(OmegaConfig.GSON.toJson((Object)config), config.getClass());
                            this.savedClientConfig.add(cachedClient);
                            for (Field field : server.getClass().getDeclaredFields()) {
                                if (!allSync && !Arrays.stream(field.getAnnotations()).anyMatch(annotation -> annotation instanceof Syncing)) continue;
                                try {
                                    field.setAccessible(true);
                                    Object serverValue = field.get(server);
                                    field.set(config, serverValue);
                                }
                                catch (IllegalAccessException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    });
                }
            });
        });
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="RETURN")})
    private void restoreConfigurations(CallbackInfo ci) {
        for (Config config : this.savedClientConfig) {
            for (Config potentiallySynced : OmegaConfig.getRegisteredConfigurations()) {
                if (!config.getName().equals(potentiallySynced.getName())) continue;
                boolean allConfigSyncs = Arrays.stream(config.getClass().getAnnotations()).anyMatch(annotation -> annotation instanceof Syncing);
                for (Field field : config.getClass().getDeclaredFields()) {
                    if (!allConfigSyncs && !Arrays.stream(field.getAnnotations()).anyMatch(annotation -> annotation instanceof Syncing)) continue;
                    try {
                        field.setAccessible(true);
                        Object preSyncValue = field.get(config);
                        field.set(potentiallySynced, preSyncValue);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.savedClientConfig.clear();
    }
}

