/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.tiab.common.misc;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.mangorage.tiab.common.lang.Styles;
import org.mangorage.tiab.common.lang.Translation;

public final class CommonHelper {
    public static Component getTotalTimeTranslated(int totalAccumulatedTime) {
        int totalAccumulatedTimeSeconds = totalAccumulatedTime / 20;
        int totalAccumulatedHours = totalAccumulatedTimeSeconds / 3600;
        int totalAccumulatedMinutes = totalAccumulatedTimeSeconds % 3600 / 60;
        int totalAccumulatedSeconds = totalAccumulatedTimeSeconds % 60;
        return Translation.TOOLTIP_TOTAL_ACCUMULATED_TIME.componentTranslation(String.format("%02d", totalAccumulatedHours), String.format("%02d", totalAccumulatedMinutes), String.format("%02d", totalAccumulatedSeconds)).setStyle(Styles.GRAY);
    }

    public static Component getStoredTimeTranslated(int storedTime) {
        int storedSeconds = storedTime / 20;
        int hours = storedSeconds / 3600;
        int minutes = storedSeconds % 3600 / 60;
        int seconds = storedSeconds % 60;
        return Translation.TOOLTIP_STORED_TIME.componentTranslation(String.format("%02d", hours), String.format("%02d", minutes), String.format("%02d", seconds)).setStyle(Styles.GREEN);
    }

    public static <T> T modify(ItemStack stack, DataComponentType<T> dataComponentType, Supplier<T> defaultComponent, Function<T, T> function) {
        Object comp = stack.getOrDefault(dataComponentType, defaultComponent.get());
        stack.set(dataComponentType, function.apply(comp));
        return (T)stack.get(dataComponentType);
    }

    public static boolean isPositive(int number) {
        return number >= 0;
    }

    public static void sendStatusMessage(ServerPlayer serverPlayer, String message) {
        serverPlayer.displayClientMessage((Component)Component.literal((String)message), true);
    }
}

