/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.block.tile;

import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import dev.qther.ars_controle.block.tile.IDimensionalHighlighter;
import dev.qther.ars_controle.config.ACServerConfig;
import dev.qther.ars_controle.registry.ACRegistry;
import dev.qther.ars_controle.util.Cached;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WarpingSpellPrismTile
extends ModdedTile
implements IWandable,
IDimensionalHighlighter {
    public static final UUID ZERO_UUID = new UUID(0L, 0L);

    public WarpingSpellPrismTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACRegistry.Tiles.WARPING_SPELL_PRISM.get(), pos, state);
    }

    @Nullable
    public HitResult getHitResult() {
        if (this.level == null || this.level.isClientSide) {
            return null;
        }
        BlockPos blockPos = this.getBlock();
        if (blockPos != null) {
            Vec3 pos = blockPos.getCenter();
            return new BlockHitResult(pos, Direction.DOWN, blockPos, true);
        }
        CompoundTag tag = this.getPersistentData();
        Entity entity = null;
        if (tag.hasUUID("entity")) {
            UUID uuid = tag.getUUID("entity");
            entity = Cached.getEntityByUUID(uuid);
        }
        if (entity == null) {
            return null;
        }
        return new EntityHitResult(entity, entity.getEyePosition());
    }

    public void setBlock(@Nullable ResourceKey<Level> level, @Nullable BlockPos block) {
        CompoundTag tag = this.getPersistentData();
        if (level == null) {
            tag.remove("dimension");
        }
        if (block == null) {
            tag.remove("block");
        }
        if (level == null || block == null) {
            this.setChanged();
            return;
        }
        tag.putString("dimension", level.location().toString());
        tag.putLong("block", block.asLong());
        tag.remove("entity");
        this.setChanged();
    }

    @Nullable
    public ServerLevel getTargetLevel() {
        if (this.level == null || this.level.isClientSide) {
            return null;
        }
        CompoundTag tag = this.getPersistentData();
        if (this.getBlock() != null) {
            String s;
            String string = s = tag.contains("dimension", 8) ? tag.getString("dimension") : null;
            if (s == null || this.level == null) {
                return null;
            }
            return Cached.getLevelByName(s);
        }
        Entity entity = this.getEntity();
        if (entity != null) {
            return (ServerLevel)entity.level();
        }
        return null;
    }

    @Nullable
    public BlockPos getBlock() {
        CompoundTag tag = this.getPersistentData();
        return tag.contains("block", 99) ? BlockPos.of((long)tag.getLong("block")) : null;
    }

    public void setEntityUUID(UUID uuid) {
        CompoundTag tag = this.getPersistentData();
        if (uuid == null) {
            tag.remove("entity");
        } else {
            tag.putUUID("entity", uuid);
        }
        tag.remove("block");
        this.setChanged();
    }

    public UUID getEntityUUID() {
        CompoundTag tag = this.getPersistentData();
        return tag.contains("entity") ? tag.getUUID("entity") : ZERO_UUID;
    }

    @Nullable
    public Entity getEntity() {
        UUID uuid = this.getEntityUUID();
        return uuid == ZERO_UUID ? null : Cached.getEntityByUUID(uuid);
    }

    public int getSourceRequired(HitResult hitResult) {
        if (hitResult == null) {
            return 0;
        }
        double distSqr = 0.0;
        int dimCost = 0;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult b = (BlockHitResult)hitResult;
            distSqr = b.getBlockPos().getCenter().distanceToSqr(this.getBlockPos().getCenter());
            if (this.getTargetLevel() != this.level) {
                dimCost = (Integer)ACServerConfig.SERVER.WARPING_SPELL_PRISM_COST_DIMENSION.get();
            }
        } else if (hitResult instanceof EntityHitResult) {
            EntityHitResult e = (EntityHitResult)hitResult;
            distSqr = e.getLocation().distanceToSqr(this.getBlockPos().getCenter());
            if (this.getTargetLevel() != this.level) {
                dimCost = (Integer)ACServerConfig.SERVER.WARPING_SPELL_PRISM_COST_DIMENSION.get();
            }
        }
        Integer costMinDistance = (Integer)ACServerConfig.SERVER.WARPING_SPELL_PRISM_COST_MIN_DISTANCE.get();
        int costMinDistanceSqr = costMinDistance * costMinDistance;
        Double costPerBlock = (Double)ACServerConfig.SERVER.WARPING_SPELL_PRISM_COST_PER_BLOCK.get();
        if (distSqr > (double)costMinDistanceSqr) {
            int maxCost = (Integer)ACServerConfig.SERVER.WARPING_SPELL_PRISM_MAX_SOURCE_COST.get();
            if (maxCost < 0) {
                maxCost = Integer.MAX_VALUE;
            }
            return Math.max(0, (int)Math.min((double)maxCost, (double)dimCost + Math.sqrt(distSqr - (double)costMinDistanceSqr) * costPerBlock));
        }
        return Math.max(0, dimCost);
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        UUID uuid = this.getEntityUUID();
        if (uuid != ZERO_UUID) {
            tag.putUUID("entity", uuid);
            return;
        }
        BlockPos pos = this.getBlock();
        if (pos != null) {
            tag.putLong("block", pos.asLong());
        }
    }

    public IWandable.Result onLastConnection(@Nullable GlobalPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player player) {
        if (storedPos != null) {
            this.setBlock((ResourceKey<Level>)storedPos.dimension(), storedPos.pos());
            this.setChanged();
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.set.block", (Object[])new Object[]{storedPos.pos().toShortString(), storedPos.dimension().location().toString()}));
            return IWandable.Result.SUCCESS;
        }
        if (storedEntity != null) {
            this.setEntityUUID(storedEntity.getUUID());
            this.setChanged();
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.set.entity", (Object[])new Object[]{storedEntity.getDisplayName(), storedEntity.level().dimension().location().toString()}));
            return IWandable.Result.SUCCESS;
        }
        return IWandable.Result.FAIL;
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player player) {
        if (storedPos != null) {
            ResourceKey dim = player.level().dimension();
            this.setBlock((ResourceKey<Level>)dim, storedPos);
            this.setChanged();
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.set.block", (Object[])new Object[]{storedPos.toShortString(), dim.location().toString()}));
            return;
        }
        if (storedEntity != null) {
            this.setEntityUUID(storedEntity.getUUID());
            this.setChanged();
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.set.entity", (Object[])new Object[]{storedEntity.getDisplayName(), storedEntity.level().dimension().location().toString()}));
        }
    }

    public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        HitResult target = this.getHitResult();
        return target == null ? List.of() : List.of(new ColorPos(target.getLocation()));
    }

    @Override
    public List<ColorPos> getWandHighlight(Level level, List<ColorPos> list) {
        HitResult target;
        ServerLevel dim = this.getTargetLevel();
        if (dim == level && (target = this.getHitResult()) != null) {
            list.add(new ColorPos(target.getLocation()));
        }
        return list;
    }
}

