/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.mixin;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.authlib.GameProfile;
import dev.qther.ars_controle.registry.ACRegistry;
import dev.qther.ars_controle.util.Cached;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RitualBrazierTile.class}, remap=false)
public abstract class RitualBrazierTileMixin
extends BlockEntity {
    @Shadow
    public AbstractRitual ritual;

    public RitualBrazierTileMixin(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lcom/hollingsworth/arsnouveau/api/ritual/AbstractRitual;tryTick(Lcom/hollingsworth/arsnouveau/common/block/tile/RitualBrazierTile;)V")})
    public void tryTick(AbstractRitual instance, RitualBrazierTile tickingTile, Operation<Void> original) {
        if (this.level == null || this.level.isClientSide) {
            original.call(new Object[]{instance, tickingTile});
            return;
        }
        if (this.hasData(ACRegistry.Attachments.RELAY_UUID)) {
            return;
        }
        original.call(new Object[]{instance, tickingTile});
    }

    @Inject(method={"getTooltip"}, at={@At(value="RETURN")})
    public void addTooltip(List<Component> tooltips, CallbackInfo ci) {
        if (this.ritual == null) {
            return;
        }
        RitualBrazierTile tile = this.ritual.tile;
        if (tile == null) {
            return;
        }
        Optional data = tile.getExistingData(ACRegistry.Attachments.ASSOCIATION);
        if (data.isPresent()) {
            try {
                UUID uuid = (UUID)data.get();
                String name = null;
                Optional profile = Cached.getGameProfileFromUUID(uuid).getNow(Optional.empty());
                if (profile.isPresent()) {
                    name = ((GameProfile)profile.get()).getName();
                }
                tooltips.add((Component)Component.translatable((String)"ars_controle.portable_brazier_relay.relayed_to", (Object[])new Object[]{name != null ? name : uuid.toString()}).withStyle(ChatFormatting.GOLD));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

