/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yogpc.qp.machine.PickIterator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public record Area(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Direction direction) {
    public static final MapCodec<Area> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.INT.fieldOf("minX").forGetter(Area::minX), (App)Codec.INT.fieldOf("minY").forGetter(Area::minY), (App)Codec.INT.fieldOf("minZ").forGetter(Area::minZ), (App)Codec.INT.fieldOf("maxX").forGetter(Area::maxX), (App)Codec.INT.fieldOf("maxY").forGetter(Area::maxY), (App)Codec.INT.fieldOf("maxZ").forGetter(Area::maxZ), (App)Direction.CODEC.fieldOf("direction").forGetter(Area::direction)).apply((Applicative)i, Area::new));

    public Area {
        if (minX > maxX) {
            throw new IllegalArgumentException("MinX(%d) must be less than or equal to MaxX(%d)".formatted(minX, maxX));
        }
        if (minY > maxY) {
            throw new IllegalArgumentException("MinY(%d) must be less than or equal to MaxY(%d)".formatted(minY, maxY));
        }
        if (minZ > maxZ) {
            throw new IllegalArgumentException("MinZ(%d) must be less than or equal to MaxZ(%d)".formatted(minZ, maxZ));
        }
    }

    public Area(Vec3i pos1, Vec3i pos2, Direction direction) {
        this(Math.min(pos1.getX(), pos2.getX()), Math.min(pos1.getY(), pos2.getY()), Math.min(pos1.getZ(), pos2.getZ()), Math.max(pos1.getX(), pos2.getX()), Math.max(pos1.getY(), pos2.getY()), Math.max(pos1.getZ(), pos2.getZ()), direction);
    }

    public static Area assumeY(Area area) {
        int distanceY = area.maxY() - area.minY();
        if (distanceY >= 4) {
            return area;
        }
        return new Area(area.minX(), area.minY(), area.minZ(), area.maxX(), area.minY() + 4, area.maxZ(), area.direction());
    }

    public boolean inAreaX(int x) {
        return this.minX < x && x < this.maxX;
    }

    public boolean inAreaZ(int z) {
        return this.minZ < z && z < this.maxZ;
    }

    public boolean inAreaXZ(Vec3i pos) {
        return this.inAreaX(pos.getX()) && this.inAreaZ(pos.getZ());
    }

    public boolean isEdge(Vec3i pos) {
        boolean zCondition;
        boolean xCondition = pos.getX() == this.minX || pos.getX() == this.maxX;
        boolean bl = zCondition = pos.getZ() == this.minZ || pos.getZ() == this.maxZ;
        if (xCondition && zCondition) {
            return true;
        }
        return xCondition && this.inAreaZ(pos.getZ()) || zCondition && this.inAreaX(pos.getX());
    }

    @VisibleForTesting
    public Area shrink(int x, int y, int z) {
        int x1 = this.minX + x;
        int x2 = this.maxX - x;
        int y1 = this.minY + y;
        int y2 = this.maxY - y;
        int z1 = this.minZ + z;
        int z2 = this.maxZ - z;
        return new Area(Math.min(x1, x2), Math.min(y1, y2), Math.min(z1, z2), Math.max(x1, x2), Math.max(y1, y2), Math.max(z1, z2), this.direction);
    }

    public Set<BlockPos> getChainBlocks(BlockPos start, Predicate<BlockPos> filter, int maxY) {
        HashSet<BlockPos> counted = new HashSet<BlockPos>((this.maxX - this.minX) * (this.maxZ - this.minZ));
        EnumSet<Direction> directions = EnumSet.of(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP);
        Set<BlockPos> search = Set.of(start);
        HashSet<BlockPos> checked = new HashSet<BlockPos>((this.maxX - this.minX) * (this.maxZ - this.minZ));
        while (!search.isEmpty()) {
            HashSet<BlockPos> nextSearch = new HashSet<BlockPos>();
            for (BlockPos pos : search) {
                checked.add(pos);
                if (!filter.test(pos) || !counted.add(pos)) continue;
                directions.stream().map(arg_0 -> ((BlockPos)pos).relative(arg_0)).filter(this::inAreaXZ).filter(p -> p.getY() <= maxY).filter(Predicate.not(checked::contains)).forEach(nextSearch::add);
            }
            search = nextSearch;
        }
        return counted;
    }

    public Set<BlockPos> getEdgeForPos(BlockPos pos) {
        boolean zCondition;
        boolean xCondition = pos.getX() == this.minX + 1 || pos.getX() == this.maxX - 1;
        boolean bl = zCondition = pos.getZ() == this.minZ + 1 || pos.getZ() == this.maxZ - 1;
        if (!xCondition && !zCondition) {
            return Set.of();
        }
        return Stream.of(pos.offset(1, 0, 0), pos.offset(-1, 0, 0), pos.offset(0, 0, 1), pos.offset(0, 0, -1), pos.offset(1, 0, 1), pos.offset(-1, 0, 1), pos.offset(-1, 0, -1), pos.offset(1, 0, -1)).filter(this::isEdge).collect(Collectors.toSet());
    }

    public PickIterator<BlockPos> quarryFramePosIterator() {
        return new QuarryFramePosIterator(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public PickIterator<BlockPos> quarryDigPosIterator(int y) {
        if (this.maxX - this.minX < 2 || this.maxZ - this.minZ < 2) {
            return PickIterator.empty();
        }
        return new QuarryDigPosIterator(this, y);
    }

    static class QuarryFramePosIterator
    extends PickIterator<BlockPos> {
        private final int minX;
        private final int minY;
        private final int minZ;
        private final int maxX;
        private final int maxY;
        private final int maxZ;

        public QuarryFramePosIterator(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        @Override
        @NotNull
        protected BlockPos update() {
            if (this.lastReturned == null) {
                return new BlockPos(this.minX, this.minY, this.minZ);
            }
            if (((BlockPos)this.lastReturned).getY() == this.minY || ((BlockPos)this.lastReturned).getY() == this.maxY) {
                if (((BlockPos)this.lastReturned).getZ() == this.minZ && ((BlockPos)this.lastReturned).getX() < this.maxX) {
                    return ((BlockPos)this.lastReturned).offset(1, 0, 0);
                }
                if (((BlockPos)this.lastReturned).getX() == this.maxX && ((BlockPos)this.lastReturned).getZ() < this.maxZ) {
                    return ((BlockPos)this.lastReturned).offset(0, 0, 1);
                }
                if (((BlockPos)this.lastReturned).getZ() == this.maxZ && ((BlockPos)this.lastReturned).getX() > this.minX && ((BlockPos)this.lastReturned).getZ() != this.minZ) {
                    return ((BlockPos)this.lastReturned).offset(-1, 0, 0);
                }
                if (((BlockPos)this.lastReturned).getX() == this.minX && ((BlockPos)this.lastReturned).getZ() > this.minZ + 1 && ((BlockPos)this.lastReturned).getX() != this.maxX) {
                    return ((BlockPos)this.lastReturned).offset(0, 0, -1);
                }
                if (((BlockPos)this.lastReturned).getY() == this.minY) {
                    return new BlockPos(this.minX, this.minY + 1, this.minZ);
                }
                if (((BlockPos)this.lastReturned).getY() == this.maxY) {
                    throw new NoSuchElementException("Iterator end: " + String.valueOf(this.lastReturned));
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf(this.lastReturned));
            }
            if (this.minY < ((BlockPos)this.lastReturned).getY() && ((BlockPos)this.lastReturned).getY() < this.maxY) {
                if (this.minX == this.maxX && this.minZ == this.maxZ) {
                    return new BlockPos(this.minX, ((BlockPos)this.lastReturned).getY() + 1, this.maxZ);
                }
                if (this.minX == this.maxX) {
                    if (((BlockPos)this.lastReturned).getZ() == this.minZ) {
                        return new BlockPos(this.minX, ((BlockPos)this.lastReturned).getY(), this.maxZ);
                    }
                    return new BlockPos(this.minX, ((BlockPos)this.lastReturned).getY() + 1, this.minZ);
                }
                if (this.minZ == this.maxZ) {
                    if (((BlockPos)this.lastReturned).getX() == this.minX) {
                        return new BlockPos(this.maxX, ((BlockPos)this.lastReturned).getY(), this.minZ);
                    }
                    return new BlockPos(this.minX, ((BlockPos)this.lastReturned).getY() + 1, this.minZ);
                }
                if (((BlockPos)this.lastReturned).getX() == this.minX && ((BlockPos)this.lastReturned).getZ() == this.minZ) {
                    return new BlockPos(this.maxX, ((BlockPos)this.lastReturned).getY(), this.minZ);
                }
                if (((BlockPos)this.lastReturned).getX() == this.maxX && ((BlockPos)this.lastReturned).getZ() == this.minZ) {
                    return new BlockPos(this.maxX, ((BlockPos)this.lastReturned).getY(), this.maxZ);
                }
                if (((BlockPos)this.lastReturned).getX() == this.maxX && ((BlockPos)this.lastReturned).getZ() == this.maxZ) {
                    return new BlockPos(this.minX, ((BlockPos)this.lastReturned).getY(), this.maxZ);
                }
                if (((BlockPos)this.lastReturned).getX() == this.minX && ((BlockPos)this.lastReturned).getZ() == this.maxZ) {
                    return new BlockPos(this.minX, ((BlockPos)this.lastReturned).getY() + 1, this.minZ);
                }
            }
            throw new IllegalStateException("Unexpected value: " + String.valueOf(this.lastReturned));
        }

        @Override
        public boolean hasNext() {
            if (this.lastReturned == null) {
                return true;
            }
            if (this.minX == this.maxX) {
                return ((BlockPos)this.lastReturned).getZ() != this.maxZ || ((BlockPos)this.lastReturned).getY() != this.maxY;
            }
            if (this.minZ == this.maxZ) {
                return ((BlockPos)this.lastReturned).getX() != this.maxX || ((BlockPos)this.lastReturned).getY() != this.maxY;
            }
            return ((BlockPos)this.lastReturned).getX() != this.minX || ((BlockPos)this.lastReturned).getY() != this.maxY || ((BlockPos)this.lastReturned).getZ() != this.minZ + 1;
        }
    }

    static class QuarryDigPosIterator
    extends PickIterator<BlockPos> {
        private final Area area;
        private final int y;

        QuarryDigPosIterator(Area area, int y) {
            this.area = area;
            this.y = y;
        }

        @Override
        protected BlockPos update() {
            int nextX;
            int nextZ;
            if (this.lastReturned == null) {
                int x = this.y % 2 == 0 ? this.area.minX() + 1 : this.area.maxX() - 1;
                int z = QuarryDigPosIterator.initZ(x, this.y, this.area.minZ, this.area.maxZ);
                return new BlockPos(x, this.y, z);
            }
            int n = nextZ = ((BlockPos)this.lastReturned).getX() % 2 == 0 ^ this.y % 2 == 0 ? ((BlockPos)this.lastReturned).getZ() + 1 : ((BlockPos)this.lastReturned).getZ() - 1;
            if (this.area.inAreaZ(nextZ)) {
                return new BlockPos(((BlockPos)this.lastReturned).getX(), this.y, nextZ);
            }
            int n2 = nextX = this.y % 2 == 0 ? ((BlockPos)this.lastReturned).getX() + 1 : ((BlockPos)this.lastReturned).getX() - 1;
            if (this.area.inAreaX(nextX)) {
                return new BlockPos(nextX, this.y, QuarryDigPosIterator.initZ(nextX, this.y, this.area.minZ, this.area.maxZ));
            }
            throw new NoSuchElementException("Iterator end: " + String.valueOf(this.lastReturned));
        }

        @Override
        public boolean hasNext() {
            if (this.lastReturned == null) {
                return true;
            }
            int endX = this.y % 2 == 0 ? this.area.maxX() - 1 : this.area.minX() + 1;
            int endZ = ((BlockPos)this.lastReturned).getX() % 2 == 0 ^ this.y % 2 == 0 ? this.area.maxZ() - 1 : this.area.minZ() + 1;
            return ((BlockPos)this.lastReturned).getX() != endX || ((BlockPos)this.lastReturned).getZ() != endZ;
        }

        static int initZ(int x, int y, int minZ, int maxZ) {
            return x % 2 == 0 ^ y % 2 == 0 ? minZ + 1 : maxZ - 1;
        }
    }
}

