/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine;

import com.yogpc.qp.QuarryPlus;
import java.util.HashMap;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class EnergyCounter {
    private static final Logger LOGGER = QuarryPlus.LOGGER;
    private static final Marker MARKER_TICK = MarkerFactory.getMarker((String)"TickLog");
    private static final Marker MARKER_FINAL = MarkerFactory.getMarker((String)"Total");
    final String name;
    final long logInterval;

    public EnergyCounter(String name) {
        this.name = name;
        this.logInterval = 100L;
    }

    public static EnergyCounter createInstance(boolean isDebug, String name) {
        if (isDebug) {
            return new Debug(name);
        }
        return new Production();
    }

    public abstract void logOutput(long var1);

    public abstract void logUsageMap();

    public abstract void useEnergy(LongSupplier var1, long var2, String var4);

    public abstract void getEnergy(LongSupplier var1, long var2);

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + "', logInterval=" + this.logInterval + "}";
    }

    public static String formatEnergyInFE(long energy) {
        return EnergyCounter.formatEnergyInFE((double)energy / 1.0E9);
    }

    public static String formatEnergyInFE(double energy) {
        return String.format("%.3f", energy);
    }

    private static class Debug
    extends EnergyCounter {
        private long lastLogTick;
        private final Map<Long, Long> useCounter = new HashMap<Long, Long>();
        private final Map<Long, Long> getCounter = new HashMap<Long, Long>();
        private final Map<String, Long> usageMap = new HashMap<String, Long>();

        public Debug(String name) {
            super(name);
        }

        @Override
        public void logOutput(long time) {
            if (time - this.lastLogTick >= this.logInterval) {
                this.lastLogTick = time;
                LongSummaryStatistics use = this.useCounter.values().stream().collect(Collectors.summarizingLong(Long::longValue));
                LongSummaryStatistics get = this.getCounter.values().stream().collect(Collectors.summarizingLong(Long::longValue));
                if (use.getSum() != 0L && get.getSum() != 0L) {
                    LOGGER.info(MARKER_TICK, "{}: Used {} FE in {} ticks({} FE/t). Got {} FE in {} ticks({} FE/t).", new Object[]{this.name, Debug.formatEnergyInFE(use.getSum()), use.getCount(), Debug.formatEnergyInFE(use.getAverage() / 1.0E9), Debug.formatEnergyInFE(get.getSum()), get.getCount(), Debug.formatEnergyInFE(get.getAverage() / 1.0E9)});
                }
                this.useCounter.clear();
                this.getCounter.clear();
            }
        }

        @Override
        public void logUsageMap() {
            this.usageMap.entrySet().stream().map(e -> "%s -> %s".formatted(e.getKey(), Debug.formatEnergyInFE((Long)e.getValue()))).forEach(s -> LOGGER.info(MARKER_FINAL, s));
            this.usageMap.clear();
        }

        private void checkTime(long time, String name) {
            if (this.lastLogTick == 0L) {
                this.lastLogTick = time;
            } else if (time - this.lastLogTick > this.logInterval) {
                LOGGER.warn(MARKER_TICK, "The last log time reset? Last: {}, Now({}): {}", new Object[]{this.lastLogTick, name, time});
            }
        }

        @Override
        public void useEnergy(LongSupplier timeGetter, long amount, String reason) {
            long time = timeGetter.getAsLong();
            this.checkTime(time, "USE");
            this.useCounter.merge(time, amount, Long::sum);
            this.usageMap.merge(reason, amount, Long::sum);
        }

        @Override
        public void getEnergy(LongSupplier timeGetter, long amount) {
            long time = timeGetter.getAsLong();
            this.checkTime(time, "GET");
            this.getCounter.merge(time, amount, Long::sum);
        }
    }

    private static class Production
    extends EnergyCounter {
        public Production() {
            super("Production");
        }

        @Override
        public void logOutput(long time) {
        }

        @Override
        public void logUsageMap() {
        }

        @Override
        public void useEnergy(LongSupplier timeGetter, long amount, String reason) {
        }

        @Override
        public void getEnergy(LongSupplier timeGetter, long amount) {
        }
    }
}

