/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.advquarry;

import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.advquarry.AdvQuarryEntity;
import com.yogpc.qp.machine.advquarry.WorkConfig;
import com.yogpc.qp.packet.OnReceiveWithLevel;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AdvActionSyncMessage
implements CustomPacketPayload,
OnReceiveWithLevel {
    public static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"adv_action_sync_message");
    public static final CustomPacketPayload.Type<AdvActionSyncMessage> TYPE = new CustomPacketPayload.Type(NAME);
    public static final StreamCodec<FriendlyByteBuf, AdvActionSyncMessage> STREAM_CODEC = CustomPacketPayload.codec(AdvActionSyncMessage::write, AdvActionSyncMessage::new);
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    @Nullable
    private final Area area;
    @NotNull
    private final WorkConfig workConfig;
    private final boolean syncArea;

    AdvActionSyncMessage(BlockPos pos, ResourceKey<Level> dim, @Nullable Area area, @NotNull WorkConfig workConfig, boolean syncArea) {
        this.pos = pos;
        this.dim = dim;
        this.area = area;
        this.workConfig = workConfig;
        this.syncArea = syncArea;
    }

    AdvActionSyncMessage(AdvQuarryEntity entity, boolean syncArea) {
        this(entity.getBlockPos(), (ResourceKey<Level>)Objects.requireNonNull(entity.getLevel()).dimension(), entity.getArea(), entity.workConfig, syncArea);
    }

    AdvActionSyncMessage(FriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.dim = buffer.readResourceKey(Registries.DIMENSION);
        boolean shouldAreaLoad = buffer.readBoolean();
        this.area = shouldAreaLoad ? (Area)buffer.readJsonWithCodec(Area.CODEC.codec()) : null;
        this.workConfig = (WorkConfig)buffer.readJsonWithCodec(WorkConfig.CODEC.codec());
        this.syncArea = buffer.readBoolean();
    }

    void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos).writeResourceKey(this.dim);
        if (this.area == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.writeJsonWithCodec(Area.CODEC.codec(), (Object)this.area);
        }
        buffer.writeJsonWithCodec(WorkConfig.CODEC.codec(), (Object)this.workConfig);
        buffer.writeBoolean(this.syncArea);
    }

    @Override
    public void onReceive(Level level, Player player) {
        if (!level.dimension().equals(this.dim)) {
            return;
        }
        BlockEntity entity = level.getBlockEntity(this.pos);
        if (entity instanceof AdvQuarryEntity) {
            AdvQuarryEntity quarry = (AdvQuarryEntity)entity;
            if (quarry.enabled) {
                if (this.syncArea) {
                    quarry.setArea(this.area);
                }
                quarry.workConfig = this.workConfig;
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdvActionSyncMessage that = (AdvActionSyncMessage)o;
        return this.syncArea == that.syncArea && Objects.equals(this.pos, that.pos) && Objects.equals(this.dim, that.dim) && Objects.equals(this.area, that.area) && Objects.equals(this.workConfig, that.workConfig);
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.dim, this.area, this.workConfig, this.syncArea);
    }
}

