/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.marker;

import com.yogpc.qp.machine.GeneralScreenHandler;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.machine.marker.ChunkMarkerEntity;
import com.yogpc.qp.machine.marker.ExMarkerBlock;
import com.yogpc.qp.machine.marker.MarkerContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public final class ChunkMarkerBlock
extends ExMarkerBlock {
    public static final String NAME = "chunk_marker";

    public ChunkMarkerBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.NONE).pushReaction(PushReaction.DESTROY).instabreak().lightLevel(value -> 7).noCollission(), NAME);
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        double angle = ChunkMarkerBlock.inRange(placer != null ? (double)placer.getYHeadRot() : 0.0, 0.0, 360.0);
        Direction.AxisDirection z = angle < 90.0 || angle >= 270.0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        Direction.AxisDirection x = angle > 180.0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        this.getBlockEntityType().map(t -> (ChunkMarkerEntity)t.getBlockEntity((BlockGetter)level, pos)).ifPresent(t -> t.init(x, z));
    }

    @Override
    protected GeneralScreenHandler<?> getScreenHandler(QpEntity entity) {
        return new GeneralScreenHandler<MarkerContainer>(entity, MarkerContainer::createChunkMarkerContainer);
    }

    static double inRange(double value, double min, double max) {
        double range = max - min;
        return value - range * Math.floor((value - min) / range);
    }
}

