/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.placer;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.placer.AbstractPlacerTile;
import com.yogpc.qp.machine.placer.PlacerContainer;
import com.yogpc.qp.machine.placer.RemotePlacerEntity;
import com.yogpc.qp.machine.placer.RemotePlacerMessage;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class RemotePlacerScreen
extends AbstractContainerScreen<PlacerContainer> {
    private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"textures/gui/remote_replacer.png");

    public RemotePlacerScreen(PlacerContainer menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        graphics.blit(LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int oneBox = 18;
        int x = ((PlacerContainer)this.getMenu()).startX - 1 + ((PlacerContainer)this.getMenu()).tile.getLastPlacedIndex() % 3 * oneBox;
        int y = 16 + ((PlacerContainer)this.getMenu()).tile.getLastPlacedIndex() / 3 * oneBox;
        int pX = this.leftPos + x;
        int pY = this.topPos + y;
        graphics.blit(LOCATION, pX, pY, 176, 0, oneBox, oneBox);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        BlockPos targetPos = ((PlacerContainer)this.getMenu()).tile.getTargetPos();
        int color = targetPos.equals((Object)((PlacerContainer)this.getMenu()).tile.getBlockPos()) ? 0xFF4040 : 0x404040;
        int x = 99;
        guiGraphics.drawString(this.font, "X: " + targetPos.getX(), x, 22, color, false);
        guiGraphics.drawString(this.font, "Y: " + targetPos.getY(), x, 40, color, false);
        guiGraphics.drawString(this.font, "Z: " + targetPos.getZ(), x, 58, color, false);
    }

    protected void init() {
        super.init();
        for (int i = 0; i < Direction.Axis.VALUES.length; ++i) {
            int yPos = this.topPos + 21 + i * 18;
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"-"), (Button.OnPress)this.onPress(Direction.Axis.VALUES[i], Direction.AxisDirection.NEGATIVE)).pos(this.leftPos + 80, yPos).size(18, 9).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"+"), (Button.OnPress)this.onPress(Direction.Axis.VALUES[i], Direction.AxisDirection.POSITIVE)).pos(this.leftPos + 151, yPos).size(18, 9).build());
        }
    }

    private Button.OnPress onPress(Direction.Axis axis, Direction.AxisDirection axisDirection) {
        return button -> {
            AbstractPlacerTile patt0$temp = ((PlacerContainer)this.getMenu()).tile;
            if (patt0$temp instanceof RemotePlacerEntity) {
                BlockPos newPos;
                RemotePlacerEntity remotePlacer = (RemotePlacerEntity)patt0$temp;
                remotePlacer.targetPos = newPos = remotePlacer.getTargetPos().relative(axis, axisDirection.getStep());
                PlatformAccess.getAccess().packetHandler().sendToServer(new RemotePlacerMessage(remotePlacer, newPos));
            }
        };
    }
}

