/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.marker.NormalMarkerEntity;
import com.yogpc.qp.machine.marker.QuarryMarker;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.ColorBox;
import com.yogpc.qp.render.Sprites;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;

public class RenderMarker
implements BlockEntityRenderer<NormalMarkerEntity> {
    private static final double a = 0.5;
    private static final double b = 0.625;
    private static final double c = 0.375;

    public RenderMarker(BlockEntityRendererProvider.Context context) {
    }

    public void render(NormalMarkerEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Minecraft.getInstance().getProfiler().push("quarryplus");
        Minecraft.getInstance().getProfiler().push("RenderMarker");
        if (blockEntity.getStatus() == NormalMarkerEntity.Status.CONNECTED_MASTER) {
            BlockPos markerPos = blockEntity.getBlockPos();
            poseStack.pushPose();
            poseStack.translate((float)(-markerPos.getX()), (float)(-markerPos.getY()), (float)(-markerPos.getZ()));
            blockEntity.getLink().ifPresent(link -> RenderMarker.renderLink(poseStack, bufferSource, link, ColorBox.markerBlueColor));
            poseStack.popPose();
        }
        Minecraft.getInstance().getProfiler().pop();
        Minecraft.getInstance().getProfiler().pop();
    }

    public static void renderLink(PoseStack poseStack, MultiBufferSource bufferSource, QuarryMarker.Link link, ColorBox color) {
        TextureAtlasSprite sprite = Sprites.INSTANCE.getWhite();
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.cutout());
        for (Box box : RenderMarker.getRenderBox(link.area())) {
            box.render(buffer, poseStack, sprite, color);
        }
    }

    public static List<Box> getRenderBox(Area area) {
        int flag = 0;
        int xMin = area.minX();
        int yMin = area.minY();
        int zMin = area.minZ();
        int xMax = area.maxX();
        int yMax = area.maxY();
        int zMax = area.maxZ();
        if (xMin != xMax) {
            flag |= 1;
        }
        if (yMin != yMax) {
            flag |= 2;
        }
        if (zMin != zMax) {
            flag |= 4;
        }
        ArrayList<AABB> boxes = new ArrayList<AABB>(12);
        if ((flag & 1) == 1) {
            boxes.add(new AABB((double)xMin + 0.625, (double)yMin + 0.5, (double)zMin + 0.5, (double)xMax + 0.375, (double)yMin + 0.5, (double)zMin + 0.5));
        }
        if ((flag & 2) == 2) {
            boxes.add(new AABB((double)xMin + 0.5, (double)yMin + 0.625, (double)zMin + 0.5, (double)xMin + 0.5, (double)yMax + 0.375, (double)zMin + 0.5));
        }
        if ((flag & 4) == 4) {
            boxes.add(new AABB((double)xMin + 0.5, (double)yMin + 0.5, (double)zMin + 0.625, (double)xMin + 0.5, (double)yMin + 0.5, (double)zMax + 0.375));
        }
        if ((flag & 3) == 3) {
            boxes.add(new AABB((double)xMin + 0.625, (double)yMax + 0.5, (double)zMin + 0.5, (double)xMax + 0.375, (double)yMax + 0.5, (double)zMin + 0.5));
            boxes.add(new AABB((double)xMax + 0.5, (double)yMin + 0.625, (double)zMin + 0.5, (double)xMax + 0.5, (double)yMax + 0.375, (double)zMin + 0.5));
        }
        if ((flag & 5) == 5) {
            boxes.add(new AABB((double)xMin + 0.625, (double)yMin + 0.5, (double)zMax + 0.5, (double)xMax + 0.375, (double)yMin + 0.5, (double)zMax + 0.5));
            boxes.add(new AABB((double)xMax + 0.5, (double)yMin + 0.5, (double)zMin + 0.625, (double)xMax + 0.5, (double)yMin + 0.5, (double)zMax + 0.375));
        }
        if ((flag & 6) == 6) {
            boxes.add(new AABB((double)xMin + 0.5, (double)yMin + 0.625, (double)zMax + 0.5, (double)xMin + 0.5, (double)yMax + 0.375, (double)zMax + 0.5));
            boxes.add(new AABB((double)xMin + 0.5, (double)yMax + 0.5, (double)zMin + 0.625, (double)xMin + 0.5, (double)yMax + 0.5, (double)zMax + 0.375));
        }
        if ((flag & 7) == 7) {
            boxes.add(new AABB((double)xMin + 0.625, (double)yMax + 0.5, (double)zMax + 0.5, (double)xMax + 0.375, (double)yMax + 0.5, (double)zMax + 0.5));
            boxes.add(new AABB((double)xMax + 0.5, (double)yMin + 0.625, (double)zMax + 0.5, (double)xMax + 0.5, (double)yMax + 0.375, (double)zMax + 0.5));
            boxes.add(new AABB((double)xMax + 0.5, (double)yMax + 0.5, (double)zMin + 0.625, (double)xMax + 0.5, (double)yMax + 0.5, (double)zMax + 0.375));
        }
        return boxes.stream().map(range -> Box.apply(range, Math.max(range.getXsize(), 0.126), Math.max(range.getYsize(), 0.126), Math.max(range.getZsize(), 0.126), true, true)).toList();
    }
}

