/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability;

import artifacts.component.ability.EquipmentAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.equipment.EquipmentHelper;
import artifacts.registry.ModDataComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.Holder;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public record DeathProtectionTeleport(Value<Double> teleportationChance, Value<Integer> healthRestored, Value<Integer> cooldown, Value<Boolean> consumedOnUse) implements EquipmentAbility
{
    public static final Codec<DeathProtectionTeleport> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ValueTypes.FRACTION.codec().optionalFieldOf("chance", Value.of(1.0)).forGetter(DeathProtectionTeleport::teleportationChance), (App)ValueTypes.NON_NEGATIVE_INT.codec().optionalFieldOf("health_restored", Value.of(10)).forGetter(DeathProtectionTeleport::healthRestored), (App)ValueTypes.cooldownField().forGetter(DeathProtectionTeleport::cooldown), (App)ValueTypes.BOOLEAN.codec().optionalFieldOf("consume", Value.of(true)).forGetter(DeathProtectionTeleport::consumedOnUse)).apply((Applicative)instance, DeathProtectionTeleport::new));
    public static final StreamCodec<ByteBuf, DeathProtectionTeleport> STREAM_CODEC = StreamCodec.composite(ValueTypes.FRACTION.streamCodec(), DeathProtectionTeleport::teleportationChance, ValueTypes.NON_NEGATIVE_INT.streamCodec(), DeathProtectionTeleport::healthRestored, ValueTypes.DURATION.streamCodec(), DeathProtectionTeleport::cooldown, ValueTypes.BOOLEAN.streamCodec(), DeathProtectionTeleport::consumedOnUse, DeathProtectionTeleport::new);

    public static ItemStack findTotem(LivingEntity entity) {
        for (InteractionHand hand : InteractionHand.values()) {
            Player player;
            ItemStack handItem = entity.getItemInHand(hand);
            DeathProtectionTeleport ability2 = (DeathProtectionTeleport)handItem.get(ModDataComponents.DEATH_PROTECTION_TELEPORT.get());
            if (handItem.has(ModDataComponents.DISABLED_BY_TOGGLE.get()) || ability2 == null || !ability2.isNonCosmetic() || entity instanceof Player && (player = (Player)entity).getCooldowns().isOnCooldown(handItem.getItem())) continue;
            return handItem;
        }
        return EquipmentHelper.reduceAbilities(ModDataComponents.DEATH_PROTECTION_TELEPORT.get(), entity, true, true, ItemStack.EMPTY, (ability, totem, result) -> result.isEmpty() ? totem : result);
    }

    public static void teleport(LivingEntity entity, ServerLevel level) {
        double oldX = entity.getX();
        double oldY = entity.getY();
        double oldZ = entity.getZ();
        for (int i = 0; i < 32; ++i) {
            double newX = entity.getX() + (entity.getRandom().nextDouble() - 0.5) * 32.0;
            double newY = Mth.clamp((double)(entity.getY() + (double)entity.getRandom().nextInt(16) - 8.0), (double)level.getMinBuildHeight(), (double)(level.getMinBuildHeight() + level.getLogicalHeight() - 1));
            double newZ = entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * 32.0;
            Vec3 oldPos = entity.position();
            if (oldPos.distanceToSqr(newX, newY, newZ) < 256.0) continue;
            if (entity.isPassenger()) {
                entity.stopRiding();
            }
            if (!entity.randomTeleport(newX, newY, newZ, true)) continue;
            entity.level().gameEvent((Holder)GameEvent.TELEPORT, oldPos, GameEvent.Context.of((Entity)entity));
            entity.level().playSound(null, oldX, oldY, oldZ, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
            entity.level().playSound(null, newX, newY, newZ, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
            break;
        }
    }

    @Override
    public boolean isNonCosmetic() {
        return !Mth.equal((double)((Double)this.teleportationChance().get()), (double)0.0);
    }

    @Override
    public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
        if (Mth.equal((double)((Double)this.teleportationChance().get()), (double)1.0)) {
            writer.add("constant", new Object[0]);
        } else {
            writer.add("chance", Math.round((Double)this.teleportationChance().get() * 100.0));
        }
        if (!((Boolean)this.consumedOnUse().get()).booleanValue()) {
            writer.add("not_consumed", new Object[0]);
        }
    }
}

