/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability;

import artifacts.component.ability.CompositeAbility;
import artifacts.component.ability.EquipmentAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;

public record EnchantmentLevelModifiers(List<Entry> entries) implements CompositeAbility<Entry>
{
    public static final List<ResourceKey<Enchantment>> ALLOWED_ENCHANTMENTS = List.of(Enchantments.FORTUNE, Enchantments.LOOTING, Enchantments.LURE, Enchantments.LUCK_OF_THE_SEA);
    public static final Codec<EnchantmentLevelModifiers> CODEC = CompositeAbility.codec(Entry.CODEC, EnchantmentLevelModifiers::new, EnchantmentLevelModifiers::entries);
    public static final StreamCodec<RegistryFriendlyByteBuf, EnchantmentLevelModifiers> STREAM_CODEC = CompositeAbility.streamCodec(Entry.STREAM_CODEC, EnchantmentLevelModifiers::new, EnchantmentLevelModifiers::entries);

    public record Entry(ResourceKey<Enchantment> enchantment, Value<Integer> amount) implements EquipmentAbility
    {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.ENCHANTMENT).validate(enchantment -> ALLOWED_ENCHANTMENTS.contains(enchantment) ? DataResult.success((Object)enchantment) : DataResult.error(() -> "Unsupported enchantment: %s".formatted(enchantment.location()))).fieldOf("enchantment").forGetter(Entry::enchantment), (App)ValueTypes.ENCHANTMENT_LEVEL.codec().optionalFieldOf("level", Value.of(1)).forGetter(Entry::amount)).apply((Applicative)instance, Entry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.ENCHANTMENT), Entry::enchantment, ValueTypes.ENCHANTMENT_LEVEL.streamCodec(), Entry::amount, Entry::new);

        @Override
        public boolean isNonCosmetic() {
            return (Integer)this.amount.get() > 0;
        }

        @Override
        public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
            String enchantmentName = this.enchantment().location().getPath();
            if ((Integer)this.amount().get() == 1) {
                writer.add("%s.single_level".formatted(enchantmentName), new Object[0]);
            } else {
                writer.add("%s.multiple_levels".formatted(enchantmentName), this.amount().get());
            }
        }
    }
}

