/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.config;

import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import tv.soaryn.xycraft.core.config.XyConfig;

public class CoreClientConfig
extends XyConfig {
    private final ModConfigSpec Configs;
    public final ModConfigSpec.BooleanValue ShowItemTags;
    public final ModConfigSpec.BooleanValue ShowReloadMessage;
    public final ModConfigSpec.BooleanValue ShowHiddenRecipes;
    public final ModConfigSpec.BooleanValue ShowBlockStateCounts;
    public final ModConfigSpec.DoubleValue UIInterpolationSpeed;
    public final ModConfigSpec.EnumValue<MeasuringUnit> FluidUnit;
    public final ModConfigSpec.IntValue ActuatorPickupDelay;

    public CoreClientConfig() {
        super(ModConfig.Type.CLIENT, "core");
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        this.ActuatorPickupDelay = builder.translation("config.client.xycraft_core.actuator_pickup_delay").comment("How long the delay is between breaking another block with an actuator without letting go of the `Destroy` hotkey.").defineInRange("actuator_pickup_delay", 2, 0, 5);
        String visualsGroup = "config.client.xycraft_core.visuals";
        builder.translation(visualsGroup).push("Visuals");
        this.UIInterpolationSpeed = builder.translation(visualsGroup + ".ui_interpolation_rate").comment("How fast a ui should change states each tick (example between two colors)").defineInRange("ui_interpolation_rate", 0.015, 0.001, 4.0);
        this.FluidUnit = builder.translation(visualsGroup + ".fluid_unit").comment("The unit that should be displayed when measuring fluids. Buckets, Liters, and Units are interchangeable.").defineEnum("fluid_unit", (Enum)MeasuringUnit.Buckets);
        builder.pop();
        builder.comment("Used primarily for debugging or pack creation. May not be ideal to have turned on when playing the game or publishing a pack.");
        String debugGroup = "config.client.xycraft_core.debug";
        ModConfigSpec.Builder b = builder.translation(debugGroup).push("Debug Settings");
        this.ShowItemTags = builder.translation(debugGroup + ".show_item_tags").comment("Show item tags in the tooltip of an item, when using advanced tooltips (F3 + h).").define("show_item_tags", false);
        this.ShowReloadMessage = builder.translation(debugGroup + ".show_reload_message").comment("Play a ding and print a message upon successful reload").define("show_reload_message", true);
        this.ShowHiddenRecipes = builder.translation(debugGroup + ".show_hidden_recipes").comment("Display recipes that would otherwise be hidden to the player in a recipe viewer").define("show_hidden_recipes", false);
        this.ShowBlockStateCounts = builder.translation(debugGroup + ".show_blockstate_counts").comment("To help isolate the number of blockstates each mod adds. Only turn this on if you are building a pack and wanting to help debug the amount of blocks your client has. (This runs at level join)").define("show_blockstate_counts", false);
        builder.pop();
        this.Configs = builder.build();
    }

    @Override
    public ModConfigSpec getSpec() {
        return this.Configs;
    }

    public static enum MeasuringUnit {
        Buckets("Bucket", "B", "mB"),
        Liters("Liter", "L", "mL"),
        Units("Units", "", "");

        public final String Unit;
        public final String MilliUnit;
        public final String Name;

        private MeasuringUnit(String name, String unit, String milliUnit) {
            this.Unit = unit;
            this.MilliUnit = milliUnit;
            this.Name = name;
        }
    }
}

