/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.rules;

import com.mojang.serialization.MapCodec;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.utils.rules.CoreRules;
import tv.soaryn.xycraft.core.utils.rules.FluidRuleGroup;
import tv.soaryn.xycraft.core.utils.rules.IRule;
import tv.soaryn.xycraft.core.utils.rules.IRuleType;

public record FluidTypeRule(FluidType fluidType) implements IRule,
FluidRuleGroup
{
    public static final MapCodec<FluidTypeRule> CODEC = NeoForgeRegistries.FLUID_TYPES.byNameCodec().fieldOf("fluid_type").xmap(FluidTypeRule::new, FluidTypeRule::fluidType);

    public static FluidTypeRule water() {
        return new FluidTypeRule((FluidType)NeoForgeMod.WATER_TYPE.value());
    }

    public static FluidTypeRule lava() {
        return new FluidTypeRule((FluidType)NeoForgeMod.LAVA_TYPE.value());
    }

    @Override
    public boolean matches(BlockState state) {
        return state.getFluidState().getFluidType().equals(this.fluidType());
    }

    @Override
    @NotNull
    public IRuleType<?> getType() {
        return (IRuleType)CoreRules.RuleFluidType.get();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FluidTypeRule) {
            FluidTypeRule rule = (FluidTypeRule)obj;
            return rule.fluidType().equals(this.fluidType());
        }
        return false;
    }
}

