/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.LaserGuiGraphics;
import com.direwolf20.laserio.client.screens.widgets.IconButton;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.FilterTagContainer;
import com.direwolf20.laserio.common.containers.customslot.FilterBasicSlot;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.common.network.data.GhostSlotPayload;
import com.direwolf20.laserio.common.network.data.UpdateFilterTagPayload;
import com.direwolf20.laserio.integration.mekanism.MekanismIntegration;
import com.direwolf20.laserio.integration.mekanism.MekanismStatics;
import com.direwolf20.laserio.util.MagicHelpers;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class FilterTagScreen
extends AbstractContainerScreen<FilterTagContainer> {
    private final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/filtertag.png");
    protected final FilterTagContainer container;
    private ItemStack filter;
    private boolean isAllowList;
    private EditBox tagField;
    private int page = 0;
    private int maxPages = 0;
    private int overSlot = -1;
    private int selectedSlot = -1;
    List<String> displayTags;
    List<String> tags = new ArrayList<String>();
    List<String> stackInSlotTags = new ArrayList<String>();
    int cycleRenders = 0;

    public FilterTagScreen(FilterTagContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.filter = container.filterItem;
        this.imageWidth = 200;
        this.imageHeight = 254;
        this.tags = FilterTag.getTags(this.filter);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (MiscTools.inBounds(this.getGuiLeft() + 5, this.getGuiTop() + 10, 16, 16, mouseX, mouseY)) {
            if (this.isAllowList) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.allowlist"), mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.denylist"), mouseX, mouseY);
            }
        }
        ++this.cycleRenders;
        int availableItemsstartX = this.getGuiLeft() + 7;
        int availableItemstartY = this.getGuiTop() + 47;
        int color = -2007278757;
        PoseStack matrixStack = guiGraphics.pose();
        matrixStack.pushPose();
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        guiGraphics.fillGradient(availableItemsstartX - 2, availableItemstartY - 4, availableItemsstartX + 162, availableItemstartY + 110, color, color);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        matrixStack.popPose();
        this.displayTags = new ArrayList<String>();
        this.populateStackInSlotTags();
        int tagsPerPage = 11;
        this.stackInSlotTags.sort(Comparator.naturalOrder());
        this.tags.sort(Comparator.naturalOrder());
        ArrayList<String> tempTags = new ArrayList<String>();
        tempTags.addAll(0, this.tags);
        tempTags.addAll(0, this.stackInSlotTags);
        this.maxPages = Math.max((int)Math.ceil((double)tempTags.size() / (double)tagsPerPage) - 1, 0);
        if (this.page > this.maxPages) {
            this.page = this.maxPages;
        }
        String pagesLabel = MagicHelpers.withSuffix(this.page + 1) + " / " + MagicHelpers.withSuffix(this.maxPages + 1);
        guiGraphics.drawString(this.font, pagesLabel, (availableItemsstartX - 2) / 2 + (availableItemsstartX + 162) / 2 - this.font.width(pagesLabel) / 2, this.getGuiTop() + 160, Color.DARK_GRAY.getRGB(), false);
        int itemStackMin = this.page * tagsPerPage;
        int itemStackMax = Math.min(this.page * tagsPerPage + tagsPerPage, tempTags.size());
        this.displayTags = tempTags.subList(itemStackMin, itemStackMax);
        int tagStartY = availableItemstartY;
        int slot = 0;
        this.overSlot = -1;
        LaserGuiGraphics laserGuiGraphics = new LaserGuiGraphics(this.minecraft, guiGraphics.bufferSource());
        for (String tag : this.displayTags) {
            List tagItems = BuiltInRegistries.ITEM.getTag(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)tag))).stream().flatMap(HolderSet.ListBacked::stream).toList();
            ItemStack drawStack = ItemStack.EMPTY;
            if (tagItems.size() > 0) {
                drawStack = new ItemStack((Holder)tagItems.get(this.cycleRenders / 120 % tagItems.size()));
                matrixStack.pushPose();
                if (!drawStack.isEmpty()) {
                    laserGuiGraphics.renderItemScale(8.0f, drawStack, availableItemsstartX - 4, tagStartY - 5);
                }
                matrixStack.popPose();
            }
            List tagFluids = BuiltInRegistries.FLUID.getTag(FluidTags.create((ResourceLocation)ResourceLocation.parse((String)tag))).stream().flatMap(HolderSet.ListBacked::stream).toList();
            FluidStack drawFluidStack = FluidStack.EMPTY;
            ItemStack bucketStack = ItemStack.EMPTY;
            if (tagFluids.size() > 0) {
                drawFluidStack = new FluidStack((Holder)tagFluids.get(this.cycleRenders / 120 % tagFluids.size()), 1000);
                matrixStack.pushPose();
                if (!drawFluidStack.isEmpty() && !(bucketStack = new ItemStack((ItemLike)drawFluidStack.getFluid().getBucket(), 1)).isEmpty()) {
                    laserGuiGraphics.renderItemScale(8.0f, bucketStack, availableItemsstartX - 4, tagStartY - 5);
                }
                matrixStack.popPose();
            }
            matrixStack.pushPose();
            matrixStack.scale(0.75f, 0.75f, 0.75f);
            int fontColor = this.stackInSlotTags.contains(tag) ? Color.BLUE.getRGB() : Color.DARK_GRAY.getRGB();
            guiGraphics.drawString(this.font, tag, (float)availableItemsstartX / 0.75f + 16.0f, (float)tagStartY / 0.75f, fontColor, false);
            matrixStack.popPose();
            if (MiscTools.inBounds(availableItemsstartX, tagStartY - 2, 160, 8, mouseX, mouseY)) {
                this.overSlot = slot;
                color = -2130706433;
                matrixStack.pushPose();
                RenderSystem.disableDepthTest();
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                guiGraphics.fillGradient(availableItemsstartX - 1, tagStartY - 2, availableItemsstartX + 160, tagStartY + 8, color, color);
                if (MiscTools.inBounds(availableItemsstartX, tagStartY - 2, 8, 8, mouseX, mouseY)) {
                    if (!drawStack.isEmpty()) {
                        guiGraphics.renderTooltip(this.font, drawStack, mouseX, mouseY);
                    }
                    if (!bucketStack.isEmpty()) {
                        guiGraphics.renderTooltip(this.font, bucketStack, mouseX, mouseY);
                    }
                }
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                matrixStack.popPose();
            }
            if (slot == this.selectedSlot) {
                color = -65536;
                matrixStack.pushPose();
                RenderSystem.disableDepthTest();
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                int x1 = availableItemsstartX + 160;
                int y1 = tagStartY + 10;
                guiGraphics.hLine(availableItemsstartX - 2, x1 - 0, tagStartY - 2, color);
                guiGraphics.hLine(availableItemsstartX - 2, x1 - 0, y1 - 3, color);
                guiGraphics.vLine(availableItemsstartX - 2, tagStartY - 2, y1 - 2, color);
                guiGraphics.vLine(x1 - 0, tagStartY - 2, y1 - 2, color);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                matrixStack.popPose();
            }
            tagStartY += 10;
            ++slot;
        }
    }

    private void checkTag(TagKey<?> tagKey) {
        String tag = tagKey.location().toString().toLowerCase(Locale.ROOT);
        if (!this.stackInSlotTags.contains(tag) && !this.tags.contains(tag)) {
            this.stackInSlotTags.add(tag);
        }
    }

    protected void populateStackInSlotTags() {
        this.stackInSlotTags = new ArrayList<String>();
        ItemStack stackInSlot = this.container.handler.getStackInSlot(0);
        if (!stackInSlot.isEmpty()) {
            stackInSlot.getItem().builtInRegistryHolder().tags().forEach(this::checkTag);
            Optional fluidHandlerLazyOptional = FluidUtil.getFluidHandler((ItemStack)stackInSlot);
            if (fluidHandlerLazyOptional.isPresent()) {
                IFluidHandler fluidHandler = (IFluidHandler)fluidHandlerLazyOptional.get();
                for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                    FluidStack fluidStack = fluidHandler.getFluidInTank(tank);
                    fluidStack.getFluid().builtInRegistryHolder().tags().forEach(this::checkTag);
                }
            }
            if (MekanismIntegration.isLoaded()) {
                MekanismStatics.getTagsFromItemStack(stackInSlot).forEach(this::checkTag);
            }
        }
    }

    public void init() {
        super.init();
        ArrayList<Object> leftWidgets = new ArrayList<Object>();
        this.isAllowList = FilterTag.getAllowList(this.filter);
        ResourceLocation[] allowListTextures = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/allowlistfalse.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/allowlisttrue.png")};
        leftWidgets.add((Object)new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 5, 16, 16, allowListTextures, this.isAllowList ? 1 : 0, button -> {
            this.isAllowList = !this.isAllowList;
            ((ToggleButton)button).setTexturePosition(this.isAllowList ? 1 : 0);
        }));
        ResourceLocation add = ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/add.png");
        IconButton addButton = new IconButton(this.getGuiLeft() + 155, this.getGuiTop() + 5, 16, 16, add, button -> {
            if (!this.tagField.getValue().isEmpty()) {
                String tag = this.tagField.getValue().toLowerCase(Locale.ROOT);
                if (!this.tags.contains(tag = tag.replaceAll("[^a-z0-9/:._-]", ""))) {
                    this.tags.add(tag);
                }
                this.tagField.setValue("");
            } else {
                ItemStack stack = this.container.handler.getStackInSlot(0);
                if (!stack.isEmpty()) {
                    String tag;
                    if (FilterTagScreen.hasShiftDown()) {
                        stack.getItem().builtInRegistryHolder().tags().forEach(t -> {
                            String tag = t.location().toString().toLowerCase(Locale.ROOT);
                            if (!this.tags.contains(tag)) {
                                this.tags.add(tag);
                            }
                        });
                        this.container.handler.setStackInSlot(0, ItemStack.EMPTY);
                    } else if (this.selectedSlot != -1 && !this.tags.contains(tag = this.displayTags.get(this.selectedSlot))) {
                        this.tags.add(tag);
                        this.selectedSlot = -1;
                    }
                }
            }
        });
        leftWidgets.add((Object)addButton);
        ResourceLocation remove = ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/remove.png");
        IconButton removeButton = new IconButton(this.getGuiLeft() + 135, this.getGuiTop() + 5, 16, 16, remove, button -> {
            if (this.selectedSlot != -1) {
                this.tags.remove(this.displayTags.get(this.selectedSlot));
                this.selectedSlot = -1;
            }
        });
        leftWidgets.add((Object)removeButton);
        ResourceLocation clear = ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/clear.png");
        IconButton clearButton = new IconButton(this.getGuiLeft() + 115, this.getGuiTop() + 5, 16, 16, clear, button -> this.tags.clear());
        leftWidgets.add((Object)clearButton);
        ResourceLocation pageup = ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/pageup.png");
        IconButton pageUp = new IconButton(this.getGuiLeft() + 100, this.getGuiTop() + 157, 12, 12, pageup, button -> {
            if (this.page < this.maxPages) {
                ++this.page;
            }
        });
        leftWidgets.add((Object)pageUp);
        ResourceLocation pagedown = ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/pagedown.png");
        IconButton pageDown = new IconButton(this.getGuiLeft() + 58, this.getGuiTop() + 157, 12, 12, pagedown, button -> {
            if (this.page > 0) {
                --this.page;
            }
        });
        leftWidgets.add((Object)pageDown);
        this.tagField = new EditBox(this.font, this.getGuiLeft() + 7, this.getGuiTop() + 25, 160, 15, (Component)Component.empty());
        leftWidgets.add(this.tagField);
        for (int i = 0; i < leftWidgets.size(); ++i) {
            this.addRenderableWidget((GuiEventListener)((AbstractWidget)leftWidgets.get(i)));
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        guiGraphics.blit(this.GUI, this.getGuiLeft(), this.getGuiTop(), 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateFilterTagPayload(this.isAllowList, this.tags), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.onClose();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256) {
            if (this.tagField.isFocused()) {
                this.tagField.setFocused(false);
                return true;
            }
            this.onClose();
            return true;
        }
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            if (this.tagField.isFocused()) {
                return true;
            }
            this.onClose();
            return true;
        }
        if (this.tagField.isFocused() && (p_keyPressed_1_ == 257 || p_keyPressed_1_ == 335) && !this.tagField.getValue().isEmpty()) {
            String tag = this.tagField.getValue().toLowerCase(Locale.ROOT);
            if (!this.tags.contains(tag = tag.replaceAll("[^a-z0-9/:._-]", ""))) {
                this.tags.add(tag);
            }
            this.tagField.setValue("");
            this.tagField.setValue("");
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseClicked(double x, double y, int btn) {
        if (MiscTools.inBounds(this.tagField.getX(), this.tagField.getY(), this.tagField.getWidth(), this.tagField.getHeight(), x, y) && btn == 1) {
            this.tagField.setValue("");
        }
        if (this.overSlot >= 0) {
            this.selectedSlot = this.overSlot;
            if (FilterTagScreen.hasShiftDown() && this.selectedSlot != -1) {
                String tag;
                if (this.selectedSlot >= this.stackInSlotTags.size()) {
                    this.tags.remove(this.displayTags.get(this.selectedSlot));
                    this.selectedSlot = -1;
                    return true;
                }
                if (this.selectedSlot < this.stackInSlotTags.size() && !this.tags.contains(tag = this.displayTags.get(this.selectedSlot))) {
                    this.tags.add(tag);
                    this.selectedSlot = -1;
                    return true;
                }
            }
            return true;
        }
        if (this.hoveredSlot instanceof FilterBasicSlot) {
            ItemStack stack = ((FilterTagContainer)this.menu).getCarried();
            stack = stack.copy().split(this.hoveredSlot.getMaxStackSize());
            this.hoveredSlot.set(stack);
            PacketDistributor.sendToServer((CustomPacketPayload)new GhostSlotPayload(this.hoveredSlot.index, stack, stack.getCount(), -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        return super.mouseClicked(x, y, btn);
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta, double deltaY) {
        if (this.hoveredSlot == null) {
            if (delta == -1.0) {
                if (this.page < this.maxPages) {
                    ++this.page;
                }
            } else if (this.page > 0) {
                --this.page;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, delta, deltaY);
    }

    private static MutableComponent getTrans(String key, Object ... args) {
        return Component.translatable((String)("laserio." + key), (Object[])args);
    }
}

