/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items.filters;

import com.direwolf20.laserio.client.events.EventTooltip;
import com.direwolf20.laserio.common.items.filters.FilterNBT;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.setup.LaserIODataComponents;
import com.direwolf20.laserio.util.MiscTools;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BaseFilter
extends Item {
    public BaseFilter() {
        super(new Item.Properties());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        boolean sneakPressed = Screen.hasShiftDown();
        if (!sneakPressed) {
            tooltip.add((Component)Component.translatable((String)"laserio.tooltip.item.show_settings").withStyle(ChatFormatting.GRAY));
        } else {
            MutableComponent toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.filter.type", ChatFormatting.GRAY.getColor());
            boolean allowMode = BaseFilter.getAllowList(stack);
            String allowString = allowMode ? "laserio.tooltip.item.filter.type.allow" : "laserio.tooltip.item.filter.type.deny";
            int allowColor = allowMode ? ChatFormatting.GREEN.getColor() : ChatFormatting.RED.getColor();
            toWrite.append((Component)MiscTools.tooltipMaker(allowString, allowColor));
            tooltip.add((Component)toWrite);
            if (!(stack.getItem() instanceof FilterTag) && !(stack.getItem() instanceof FilterNBT)) {
                toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.filter.nbt", ChatFormatting.GRAY.getColor());
                boolean nbtMode = BaseFilter.getCompareNBT(stack);
                String nbtString = nbtMode ? "laserio.tooltip.item.filter.nbt.allow" : "laserio.tooltip.item.filter.nbt.deny";
                int nbtColor = nbtMode ? ChatFormatting.GREEN.getColor() : ChatFormatting.RED.getColor();
                toWrite.append((Component)MiscTools.tooltipMaker(nbtString, nbtColor));
                tooltip.add((Component)toWrite);
            }
            if (!(stack.getItem() instanceof FilterTag)) {
                // empty if block
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack itemStack) {
        return Optional.of(new EventTooltip.CopyPasteTooltipComponent.Data(itemStack));
    }

    public static boolean getAllowList(ItemStack stack) {
        return (Boolean)stack.getOrDefault(LaserIODataComponents.FILTER_ALLOW, (Object)true);
    }

    public static boolean setAllowList(ItemStack stack, boolean allowList) {
        if (allowList) {
            stack.remove(LaserIODataComponents.FILTER_ALLOW);
        } else {
            stack.set(LaserIODataComponents.FILTER_ALLOW, (Object)allowList);
        }
        return allowList;
    }

    public static boolean getCompareNBT(ItemStack stack) {
        if (stack.getItem() instanceof FilterNBT) {
            return (Boolean)stack.getOrDefault(LaserIODataComponents.FILTER_COMPARE, (Object)true);
        }
        return (Boolean)stack.getOrDefault(LaserIODataComponents.FILTER_COMPARE, (Object)false);
    }

    public static boolean setCompareNBT(ItemStack stack, boolean compareNBT) {
        if (!compareNBT) {
            stack.remove(LaserIODataComponents.FILTER_COMPARE);
        } else {
            stack.set(LaserIODataComponents.FILTER_COMPARE, (Object)compareNBT);
        }
        return compareNBT;
    }
}

