/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items.filters;

import com.direwolf20.laserio.common.containers.FilterCountContainer;
import com.direwolf20.laserio.common.containers.customhandler.FilterCountHandler;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.setup.LaserIODataComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FilterCount
extends BaseFilter {
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new FilterCountContainer(windowId, playerInventory, player, itemstack), (Component)Component.translatable((String)"")), buf -> {
            ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)itemstack);
            ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)ItemStack.EMPTY);
        });
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    public static int getSlotAmount(ItemStack stack, int getSlot) {
        if (!stack.has(LaserIODataComponents.FILTER_COUNT_MBAMT)) {
            return 0;
        }
        List slotAmts = (List)stack.get(LaserIODataComponents.FILTER_COUNT_MBAMT);
        return (Integer)slotAmts.get(getSlot);
    }

    public static void setSlotAmount(ItemStack stack, int getSlot, int setMBAmount) {
        if (!stack.has(LaserIODataComponents.FILTER_COUNT_MBAMT)) {
            ArrayList<Integer> list = new ArrayList<Integer>(15);
            for (int i = 0; i < 15; ++i) {
                list.add(0);
            }
            stack.set(LaserIODataComponents.FILTER_COUNT_MBAMT, list);
        }
        List slotAmts = (List)stack.get(LaserIODataComponents.FILTER_COUNT_MBAMT);
        int amtToPut = setMBAmount % 1000;
        int stackSize = setMBAmount / 1000;
        FilterCount.setSlotCount(stack, getSlot, stackSize);
        slotAmts.set(getSlot, amtToPut);
        boolean allZeros = true;
        for (int i = 0; i < 15; ++i) {
            if ((Integer)slotAmts.get(i) == 0) continue;
            allZeros = false;
            break;
        }
        if (allZeros) {
            stack.remove(LaserIODataComponents.FILTER_COUNT_MBAMT);
        } else {
            stack.set(LaserIODataComponents.FILTER_COUNT_MBAMT, (Object)slotAmts);
        }
    }

    public static int getSlotCount(ItemStack stack, int getSlot) {
        if (!stack.has(LaserIODataComponents.FILTER_COUNT_SLOT_COUNTS)) {
            return 0;
        }
        List slotAmts = (List)stack.get(LaserIODataComponents.FILTER_COUNT_SLOT_COUNTS);
        return (Integer)slotAmts.get(getSlot);
    }

    public static void setSlotCount(ItemStack stack, int getSlot, int setCount) {
        if (!stack.has(LaserIODataComponents.FILTER_COUNT_SLOT_COUNTS)) {
            ArrayList<Integer> list = new ArrayList<Integer>(15);
            for (int i = 0; i < 15; ++i) {
                list.add(0);
            }
            stack.set(LaserIODataComponents.FILTER_COUNT_SLOT_COUNTS, list);
        }
        ArrayList<Integer> slotAmts = new ArrayList<Integer>((Collection)stack.get(LaserIODataComponents.FILTER_COUNT_SLOT_COUNTS));
        slotAmts.set(getSlot, setCount);
        boolean allZeros = true;
        for (int i = 0; i < 15; ++i) {
            if ((Integer)slotAmts.get(i) == 0) continue;
            allZeros = false;
            break;
        }
        if (allZeros) {
            stack.remove(LaserIODataComponents.FILTER_COUNT_SLOT_COUNTS);
        } else {
            stack.set(LaserIODataComponents.FILTER_COUNT_SLOT_COUNTS, slotAmts);
        }
    }

    public static FilterCountHandler getInventory(ItemStack stack) {
        FilterCountHandler handler = new FilterCountHandler(15, stack);
        return handler;
    }

    public static boolean doesItemStackHoldFluids(ItemStack stack) {
        Optional fluidHandlerLazyOptional = FluidUtil.getFluidHandler((ItemStack)stack);
        if (!fluidHandlerLazyOptional.isPresent()) {
            return false;
        }
        FluidStack fluidStack = FluidStack.EMPTY;
        IFluidHandler fluidHandler = (IFluidHandler)fluidHandlerLazyOptional.get();
        for (int tank = 0; tank < fluidHandler.getTanks() && (fluidStack = fluidHandler.getFluidInTank(tank)).isEmpty(); ++tank) {
        }
        return !fluidStack.isEmpty();
    }

    public static boolean getAllowList(ItemStack stack) {
        return (Boolean)stack.getOrDefault(LaserIODataComponents.FILTER_ALLOW, (Object)true);
    }

    public static boolean setAllowList(ItemStack stack, boolean allowList) {
        if (!allowList) {
            stack.remove(LaserIODataComponents.FILTER_ALLOW);
        } else {
            stack.set(LaserIODataComponents.FILTER_ALLOW, (Object)true);
        }
        return allowList;
    }
}

