/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.datagen.customrecipes;

import com.direwolf20.laserio.common.containers.customhandler.CardItemHandler;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.setup.Registration;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class CardClearRecipe
implements CraftingRecipe {
    final String group;
    final CraftingBookCategory category;
    final ItemStack result;
    final NonNullList<Ingredient> ingredients;
    private final boolean isSimple;

    public CardClearRecipe(String pGroup, CraftingBookCategory pCategory, ItemStack pResult, NonNullList<Ingredient> pIngredients) {
        this.group = pGroup;
        this.category = pCategory;
        this.result = pResult;
        this.ingredients = pIngredients;
        this.isSimple = pIngredients.stream().allMatch(Ingredient::isSimple);
    }

    public String getGroup() {
        return this.group;
    }

    public CraftingBookCategory category() {
        return this.category;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        StackedContents stackedcontents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < craftingInput.size(); ++j) {
            ItemStack itemstack = craftingInput.getItem(j);
            if (itemstack.isEmpty()) continue;
            ++i;
            if (this.isSimple) {
                stackedcontents.accountStack(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.ingredients.size() && (this.isSimple ? stackedcontents.canCraft((Recipe)this, null) : RecipeMatcher.findMatches(inputs, this.ingredients) != null);
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        ItemStack itemStack = craftingInput.getItem(0);
        if (itemStack.getItem() instanceof BaseCard) {
            CardItemHandler cardItemHandler = BaseCard.getInventory(itemStack);
            if (!cardItemHandler.getStackInSlot(0).isEmpty()) {
                return cardItemHandler.getStackInSlot(0);
            }
            if (!cardItemHandler.getStackInSlot(1).isEmpty()) {
                return cardItemHandler.getStackInSlot(1);
            }
        }
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= this.ingredients.size();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput craftingInput) {
        NonNullList nonnulllist = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        ItemStack itemStack = craftingInput.getItem(0);
        if (itemStack.getItem() instanceof BaseCard) {
            CardItemHandler cardItemHandler = BaseCard.getInventory(itemStack);
            if (!cardItemHandler.getStackInSlot(0).isEmpty()) {
                ItemStack returnStack = itemStack.copy();
                BaseCard.getInventory(returnStack).setStackInSlot(0, ItemStack.EMPTY);
                nonnulllist.set(0, (Object)returnStack);
                return nonnulllist;
            }
            if (!cardItemHandler.getStackInSlot(1).isEmpty()) {
                ItemStack returnStack = itemStack.copy();
                BaseCard.getInventory(returnStack).setStackInSlot(1, ItemStack.EMPTY);
                nonnulllist.set(0, (Object)returnStack);
                return nonnulllist;
            }
        } else if (itemStack.hasCraftingRemainingItem()) {
            nonnulllist.set(0, (Object)itemStack.getCraftingRemainingItem());
        }
        return nonnulllist;
    }

    public RecipeSerializer<?> getSerializer() {
        return Registration.CARD_CLEAR_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<CardClearRecipe> {
        private static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"cardclear");
        private static final MapCodec<CardClearRecipe> CODEC = RecordCodecBuilder.mapCodec(p_311734_ -> p_311734_.group((App)Codec.STRING.fieldOf("group").forGetter(p_301127_ -> p_301127_.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_301133_ -> p_301133_.category), (App)ItemStack.CODEC.fieldOf("result").forGetter(p_301142_ -> p_301142_.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(p_301021_ -> {
            Object[] aingredient = (Ingredient[])p_301021_.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth() ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth())) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(p_300975_ -> p_300975_.ingredients)).apply((Applicative)p_311734_, CardClearRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CardClearRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<CardClearRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CardClearRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static CardClearRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
            String s = pBuffer.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)pBuffer.readEnum(CraftingBookCategory.class);
            int i = pBuffer.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonnulllist.replaceAll(p_319733_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer));
            ItemStack itemstack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)pBuffer);
            return new CardClearRecipe(s, craftingbookcategory, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        public static void toNetwork(RegistryFriendlyByteBuf pBuffer, CardClearRecipe pRecipe) {
            pBuffer.writeUtf(pRecipe.group);
            pBuffer.writeEnum((Enum)pRecipe.category);
            pBuffer.writeVarInt(pRecipe.ingredients.size());
            for (Ingredient ingredient : pRecipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)ingredient);
            }
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.result);
        }
    }
}

