/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.popup;

import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiPopupCore;
import sonar.fluxnetworks.client.gui.button.FluxEditBox;
import sonar.fluxnetworks.client.gui.button.SimpleButton;
import sonar.fluxnetworks.client.gui.tab.GuiTabSelection;

public class PopupNetworkPassword
extends GuiPopupCore<GuiTabSelection> {
    private SimpleButton mCancel;
    private SimpleButton mConnect;
    public FluxEditBox mPassword;

    public PopupNetworkPassword(GuiTabSelection host) {
        super(host);
    }

    @Override
    public void init() {
        super.init();
        this.mCancel = new SimpleButton(this, this.leftPos + this.imageWidth / 2 - 12 - 48, this.topPos + 86, 48, 12, FluxTranslate.CANCEL.get());
        this.mButtons.add(this.mCancel);
        this.mConnect = new SimpleButton(this, this.leftPos + this.imageWidth / 2 + 12, this.topPos + 86, 48, 12, FluxTranslate.CONNECT.get());
        this.mConnect.setClickable(false);
        this.mButtons.add(this.mConnect);
        this.mPassword = FluxEditBox.create(FluxTranslate.NETWORK_PASSWORD.get() + ": ", this.font, this.leftPos + this.imageWidth / 2 - 60, this.topPos + 64, 120, 12);
        this.mPassword.setTextInvisible();
        this.mPassword.setMaxLength(16);
        this.mPassword.setResponder(s -> this.mConnect.setClickable(!s.isEmpty()));
        this.addRenderableWidget((GuiEventListener)this.mPassword);
    }

    @Override
    public void drawForegroundLayer(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawForegroundLayer(gr, mouseX, mouseY, deltaTicks);
        if (((GuiTabSelection)this.mHost).mSelectedNetwork != null) {
            gr.drawCenteredString(this.font, FluxTranslate.CONNECTING_TO.format(((GuiTabSelection)this.mHost).mSelectedNetwork.getNetworkName()), this.leftPos + 88, this.topPos + 48, 0xFFFFFF);
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (button == this.mCancel) {
                ((GuiTabSelection)this.mHost).closePopup();
            } else if (button == this.mConnect) {
                ((GuiTabSelection)this.mHost).setConnectedNetwork(((GuiTabSelection)this.mHost).mSelectedNetwork, this.mPassword.getValue());
                this.mPassword.setValue("");
            }
        }
    }
}

