/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.jei;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.client.jei.CreatingFluxRecipe;
import sonar.fluxnetworks.register.RegistryBlocks;
import sonar.fluxnetworks.register.RegistryItems;

@ParametersAreNonnullByDefault
public class CreatingFluxRecipeCategory
implements IRecipeCategory<CreatingFluxRecipe> {
    public static final ResourceLocation TEXTURES = FluxNetworks.location("textures/gui/gui_creating_flux_recipe.png");
    public static final RecipeType<CreatingFluxRecipe> RECIPE_TYPE = RecipeType.create((String)"fluxnetworks", (String)"creating_flux", CreatingFluxRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final ITickTimer timer;

    public CreatingFluxRecipeCategory(@Nonnull IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURES, 0, -20, 128, 80);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistryItems.FLUX_DUST.get()));
        this.timer = guiHelper.createTickTimer(60, 320, false);
    }

    @Nonnull
    public static List<CreatingFluxRecipe> getRecipes() {
        ArrayList<CreatingFluxRecipe> recipes = new ArrayList<CreatingFluxRecipe>();
        recipes.add(new CreatingFluxRecipe(Blocks.BEDROCK, Blocks.OBSIDIAN, new ItemStack((ItemLike)Items.REDSTONE), new ItemStack((ItemLike)RegistryItems.FLUX_DUST.get())));
        recipes.add(new CreatingFluxRecipe((Block)RegistryBlocks.FLUX_BLOCK.get(), Blocks.OBSIDIAN, new ItemStack((ItemLike)Items.REDSTONE), new ItemStack((ItemLike)RegistryItems.FLUX_DUST.get())));
        return recipes;
    }

    @Nonnull
    public static List<ItemStack> getCatalysts() {
        return List.of(new ItemStack((ItemLike)RegistryItems.FLUX_DUST.get()));
    }

    @Nonnull
    public RecipeType<CreatingFluxRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return FluxTranslate.JEI_CREATING_FLUX.getComponent();
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull CreatingFluxRecipe recipe, @Nonnull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 9, 25).addItemStack(recipe.input());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 25).addItemStack(recipe.output());
    }

    public void getTooltip(ITooltipBuilder tooltip, CreatingFluxRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        super.getTooltip(tooltip, (Object)recipe, recipeSlotsView, mouseX, mouseY);
        if (mouseX >= 40.0 && mouseX < 80.0 && mouseY >= 10.0 && mouseY < 64.0) {
            tooltip.addAll(List.of(Component.literal((String)"Y+2 = ").append((Component)recipe.crusher().getName()), Component.literal((String)"Y+1 = ").append(recipe.input().getHoverName()), Component.literal((String)"Y+0 = ").append((Component)recipe.base().getName())));
        }
    }

    public void draw(@Nonnull CreatingFluxRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, @Nonnull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        this.background.draw(guiGraphics);
        Quaternionf quat = new Quaternionf();
        quat.rotationXYZ(0.5235988f, 0.7853982f, 0.0f);
        guiGraphics.pose().pushPose();
        int value = this.timer.getValue();
        double offset = (float)(value > 160 ? 160 - (value - 160) : value) / 10.0f;
        guiGraphics.pose().translate(52.0, 10.0 + offset, 128.0);
        guiGraphics.pose().scale(16.0f, 16.0f, 16.0f);
        guiGraphics.pose().mulPose(quat);
        dispatcher.renderSingleBlock(recipe.crusher().defaultBlockState(), guiGraphics.pose(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(52.0f, 40.0f, 96.0f);
        guiGraphics.pose().scale(16.0f, 16.0f, 16.0f);
        guiGraphics.pose().mulPose(quat);
        dispatcher.renderSingleBlock(recipe.base().defaultBlockState(), guiGraphics.pose(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(63.0f, 36.0f, 112.0f);
        guiGraphics.pose().scale(16.0f, -16.0f, 16.0f);
        ItemStack toDisplay = value > 160 ? recipe.output() : recipe.input();
        guiGraphics.pose().mulPose(quat.rotationXYZ(toDisplay.getItem() instanceof BlockItem ? 0.5235988f : 0.0f, (-90.0f + 180.0f * ((float)value / (float)this.timer.getMaxValue())) * ((float)Math.PI / 180), 0.0f));
        itemRenderer.renderStatic(toDisplay, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, guiGraphics.pose(), (MultiBufferSource)bufferSource, null, 0);
        guiGraphics.pose().popPose();
        bufferSource.endBatch();
        Font fontRenderer = Minecraft.getInstance().font;
        String help = FluxTranslate.JEI_LEFT_CLICK.format(recipe.crusher().getName().getString());
        guiGraphics.drawString(fontRenderer, help, 64 - fontRenderer.width(help) / 2, 68, -12566464, false);
    }
}

