/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.device;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import sonar.fluxnetworks.api.energy.IBlockEnergyConnector;

public class SideTransfer {
    private final Direction mSide;
    @Nullable
    private BlockEntity mTarget;
    private IBlockEnergyConnector mAdapter;
    private ItemStack mDisplayStack = ItemStack.EMPTY;
    public long mChange;

    public SideTransfer(@Nonnull Direction direction) {
        this.mSide = direction.getOpposite();
    }

    public void set(@Nullable BlockEntity target, IBlockEnergyConnector adapter) {
        this.mTarget = target;
        this.mAdapter = adapter;
        this.mDisplayStack = target != null ? new ItemStack((ItemLike)target.getBlockState().getBlock()) : ItemStack.EMPTY;
    }

    public long send(long amount, boolean simulate) {
        if (this.mTarget == null || this.mTarget.isRemoved()) {
            return 0L;
        }
        if (this.mAdapter.canSendTo(this.mTarget, this.mSide)) {
            long op = this.mAdapter.sendTo(amount, this.mTarget, this.mSide, simulate);
            if (!simulate) {
                this.mChange -= op;
            }
            return op;
        }
        return 0L;
    }

    public void receive(long amount) {
        this.mChange += amount;
    }

    public void onCycleStart() {
        this.mChange = 0L;
    }

    @Nullable
    public BlockEntity getTarget() {
        return this.mTarget;
    }

    @Nonnull
    public ItemStack getDisplayStack() {
        return this.mDisplayStack;
    }
}

