/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.device;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import sonar.fluxnetworks.api.FluxDataComponents;
import sonar.fluxnetworks.api.device.FluxDeviceType;
import sonar.fluxnetworks.api.device.IFluxStorage;
import sonar.fluxnetworks.common.device.FluxStorageHandler;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.common.util.FluxGuiStack;
import sonar.fluxnetworks.register.Channel;
import sonar.fluxnetworks.register.Messages;
import sonar.fluxnetworks.register.RegistryBlockEntityTypes;

public abstract class TileFluxStorage
extends TileFluxDevice
implements IFluxStorage {
    private final FluxStorageHandler mHandler;

    protected TileFluxStorage(@Nonnull BlockEntityType<?> type, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull FluxStorageHandler handler) {
        super(type, pos, state);
        this.mHandler = handler;
    }

    @Override
    public long getMaxTransferLimit() {
        return this.mHandler.getMaxEnergyStorage();
    }

    @Override
    protected void onServerTick() {
        super.onServerTick();
        if ((this.mFlags & 0x200) != 0 && (this.level.getGameTime() & 7L) == 0L) {
            Channel.get().sendToTrackingChunk(Messages.makeDeviceBuffer(this, (byte)-2), this.level.getChunkAt(this.worldPosition));
            this.mFlags &= 0xFFFFFDFF;
        }
    }

    @Override
    @Nonnull
    public FluxDeviceType getDeviceType() {
        return FluxDeviceType.STORAGE;
    }

    @Override
    @Nonnull
    public FluxStorageHandler getTransferHandler() {
        return this.mHandler;
    }

    public void fillUp() {
        this.mHandler.fillUp();
        this.mFlags |= 0x200;
    }

    @Nonnull
    protected ItemStack writeToDisplayStack(@Nonnull ItemStack stack) {
        if (this.level.isClientSide) {
            stack.set(FluxDataComponents.FLUX_COLOR, Optional.empty());
        } else {
            stack.set(FluxDataComponents.FLUX_COLOR, Optional.of(this.getNetwork().getNetworkColor()));
        }
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)(this.getCustomName().isBlank() ? Language.getInstance().getOrDefault(stack.getItem().getDescriptionId()) : this.getCustomName())));
        stack.set(FluxDataComponents.STORED_ENERGY, (Object)this.getTransferBuffer());
        return stack;
    }

    public static class Gargantuan
    extends TileFluxStorage {
        public Gargantuan(@Nonnull BlockPos pos, @Nonnull BlockState state) {
            super((BlockEntityType)RegistryBlockEntityTypes.GARGANTUAN_FLUX_STORAGE.get(), pos, state, new FluxStorageHandler.Gargantuan());
        }

        @Override
        @Nonnull
        public ItemStack getDisplayStack() {
            return this.writeToDisplayStack(FluxGuiStack.GARGANTUAN_STORAGE);
        }
    }

    public static class Herculean
    extends TileFluxStorage {
        public Herculean(@Nonnull BlockPos pos, @Nonnull BlockState state) {
            super((BlockEntityType)RegistryBlockEntityTypes.HERCULEAN_FLUX_STORAGE.get(), pos, state, new FluxStorageHandler.Herculean());
        }

        @Override
        @Nonnull
        public ItemStack getDisplayStack() {
            return this.writeToDisplayStack(FluxGuiStack.HERCULEAN_STORAGE);
        }
    }

    public static class Basic
    extends TileFluxStorage {
        public Basic(@Nonnull BlockPos pos, @Nonnull BlockState state) {
            super((BlockEntityType)RegistryBlockEntityTypes.BASIC_FLUX_STORAGE.get(), pos, state, new FluxStorageHandler.Basic());
        }

        @Override
        @Nonnull
        public ItemStack getDisplayStack() {
            return this.writeToDisplayStack(FluxGuiStack.BASIC_STORAGE);
        }
    }
}

