/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.network.SecurityLevel;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.common.util.FluxUtils;
import sonar.fluxnetworks.register.Channel;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class ClientMessages {
    public static void deviceBuffer(TileFluxDevice device, byte type) {
        assert (type > 0);
        FriendlyByteBuf buf = Channel.buffer(0);
        buf.writeBlockPos(device.getBlockPos());
        buf.writeByte(type);
        device.writePacketBuffer(buf, type);
        Channel.sChannel.sendToServer(buf);
    }

    public static void superAdmin(int token, boolean enable) {
        FriendlyByteBuf buf = Channel.buffer(1);
        buf.writeByte(token);
        buf.writeBoolean(enable);
        Channel.sChannel.sendToServer(buf);
    }

    public static void createNetwork(int token, String name, int color, SecurityLevel security, String password) {
        FriendlyByteBuf buf = Channel.buffer(2);
        buf.writeByte(token);
        buf.writeUtf(name, 256);
        buf.writeInt(color);
        buf.writeByte(security.getId());
        if (security == SecurityLevel.ENCRYPTED) {
            buf.writeUtf(password, 256);
        }
        Channel.sChannel.sendToServer(buf);
    }

    public static void deleteNetwork(int token, FluxNetwork network) {
        FriendlyByteBuf buf = Channel.buffer(3);
        buf.writeByte(token);
        buf.writeInt(network.getNetworkID());
        Channel.sChannel.sendToServer(buf);
    }

    public static void editTile(int token, TileFluxDevice device, CompoundTag tag) {
        FriendlyByteBuf buf = Channel.buffer(4);
        buf.writeByte(token);
        buf.writeBlockPos(device.getBlockPos());
        buf.writeNbt((Tag)tag);
        Channel.sChannel.sendToServer(buf);
    }

    public static void tileNetwork(int token, TileFluxDevice device, FluxNetwork network, String password) {
        FriendlyByteBuf buf = Channel.buffer(5);
        buf.writeByte(token);
        buf.writeBlockPos(device.getBlockPos());
        buf.writeInt(network.getNetworkID());
        buf.writeUtf(password, 256);
        Channel.sChannel.sendToServer(buf);
    }

    public static void editMember(int token, FluxNetwork network, UUID uuid, byte type) {
        FriendlyByteBuf buf = Channel.buffer(8);
        buf.writeByte(token);
        buf.writeInt(network.getNetworkID());
        buf.writeUUID(uuid);
        buf.writeByte(type);
        Channel.sChannel.sendToServer(buf);
    }

    public static void editNetwork(int token, FluxNetwork network, String name, int color, SecurityLevel security, String password) {
        FriendlyByteBuf buf = Channel.buffer(9);
        buf.writeByte(token);
        buf.writeInt(network.getNetworkID());
        buf.writeUtf(name, 256);
        buf.writeInt(color);
        buf.writeByte(security.getId());
        if (security == SecurityLevel.ENCRYPTED) {
            buf.writeUtf(password, 256);
        }
        Channel.sChannel.sendToServer(buf);
    }

    public static void editConnection(int token, FluxNetwork network, List<GlobalPos> list, CompoundTag tag) {
        if (list.isEmpty()) {
            return;
        }
        FriendlyByteBuf buf = Channel.buffer(10);
        buf.writeByte(token);
        buf.writeInt(network.getNetworkID());
        buf.writeVarInt(list.size());
        for (GlobalPos pos : list) {
            FluxUtils.writeGlobalPos(buf, pos);
        }
        buf.writeNbt((Tag)tag);
        Channel.sChannel.sendToServer(buf);
    }

    public static void updateNetwork(int token, FluxNetwork network, byte type) {
        FriendlyByteBuf buf = Channel.buffer(11);
        buf.writeByte(token);
        buf.writeVarInt(1);
        buf.writeInt(network.getNetworkID());
        buf.writeByte(type);
        Channel.sChannel.sendToServer(buf);
    }

    public static void updateNetwork(int token, Collection<FluxNetwork> networks, byte type) {
        if (networks.isEmpty()) {
            return;
        }
        FriendlyByteBuf buf = Channel.buffer(11);
        buf.writeByte(token);
        buf.writeVarInt(networks.size());
        for (FluxNetwork network : networks) {
            buf.writeInt(network.getNetworkID());
        }
        buf.writeByte(type);
        Channel.sChannel.sendToServer(buf);
    }

    public static void wirelessMode(int token, int wirelessMode, int wirelessNetwork) {
        FriendlyByteBuf buf = Channel.buffer(12);
        buf.writeByte(token);
        buf.writeInt(wirelessMode);
        buf.writeInt(wirelessNetwork);
        Channel.sChannel.sendToServer(buf);
    }

    public static void disconnect(int token, FluxNetwork network, Collection<IFluxDevice> list) {
        if (list.isEmpty()) {
            return;
        }
        FriendlyByteBuf buf = Channel.buffer(13);
        buf.writeByte(token);
        buf.writeInt(network.getNetworkID());
        buf.writeVarInt(list.size());
        for (IFluxDevice device : list) {
            FluxUtils.writeGlobalPos(buf, device.getGlobalPos());
        }
        Channel.sChannel.sendToServer(buf);
    }

    public static void updateConnections(int token, FluxNetwork network, Collection<IFluxDevice> list) {
        if (list.isEmpty()) {
            return;
        }
        FriendlyByteBuf buf = Channel.buffer(14);
        buf.writeByte(token);
        buf.writeInt(network.getNetworkID());
        buf.writeVarInt(list.size());
        for (IFluxDevice device : list) {
            FluxUtils.writeGlobalPos(buf, device.getGlobalPos());
        }
        Channel.sChannel.sendToServer(buf);
    }

    static void msg(int index, FriendlyByteBuf payload, Supplier<LocalPlayer> player, BlockableEventLoop<?> looper) {
        switch (index) {
            case 256: {
                ClientMessages.onDeviceBuffer(payload, player, looper);
                break;
            }
            case 257: {
                ClientMessages.onResponse(payload, player, looper);
                break;
            }
            case 258: {
                ClientMessages.onCapability(payload, player, looper);
                break;
            }
            case 259: {
                ClientMessages.onUpdateNetwork(payload, player, looper);
                break;
            }
            case 260: {
                ClientMessages.onDeleteNetwork(payload, player, looper);
                break;
            }
            case 261: {
                ClientMessages.onUpdateConnections(payload, player, looper);
            }
        }
        payload.release();
    }

    private static void onDeviceBuffer(FriendlyByteBuf payload, Supplier<LocalPlayer> player, BlockableEventLoop<?> looper) {
        payload.retain();
        looper.execute(() -> {
            BlockEntity patt0$temp;
            LocalPlayer p = (LocalPlayer)player.get();
            if (p != null && (patt0$temp = p.clientLevel.getBlockEntity(payload.readBlockPos())) instanceof TileFluxDevice) {
                TileFluxDevice e = (TileFluxDevice)patt0$temp;
                byte id = payload.readByte();
                if (id < 0) {
                    e.readPacketBuffer(payload, id);
                }
            }
            payload.release();
        });
    }

    private static void onResponse(FriendlyByteBuf payload, Supplier<LocalPlayer> player, BlockableEventLoop<?> looper) {
        byte token = payload.readByte();
        short key = payload.readShort();
        byte code = payload.readByte();
        looper.execute(() -> {
            AbstractContainerMenu patt0$temp;
            LocalPlayer p = (LocalPlayer)player.get();
            if (p == null) {
                return;
            }
            if (p.containerMenu.containerId == token && (patt0$temp = p.containerMenu) instanceof FluxMenu) {
                FluxMenu m = (FluxMenu)patt0$temp;
                if (m.mOnResultListener != null) {
                    m.mOnResultListener.onResult(m, key, code);
                }
            }
        });
    }

    private static void onCapability(FriendlyByteBuf payload, Supplier<LocalPlayer> player, BlockableEventLoop<?> looper) {
        boolean superAdmin = payload.readBoolean();
        int wirelessMode = payload.readInt();
        int wirelessNetwork = payload.readInt();
        looper.execute(() -> {
            LocalPlayer p = (LocalPlayer)player.get();
            if (p == null) {
                return;
            }
            ClientCache.sSuperAdmin = superAdmin;
            ClientCache.sWirelessMode = wirelessMode;
            ClientCache.sWirelessNetwork = wirelessNetwork;
        });
    }

    private static void onUpdateNetwork(FriendlyByteBuf payload, Supplier<LocalPlayer> player, BlockableEventLoop<?> looper) {
        byte type = payload.readByte();
        int size = payload.readVarInt();
        Int2ObjectArrayMap map = new Int2ObjectArrayMap(size);
        for (int i = 0; i < size; ++i) {
            int id = payload.readInt();
            CompoundTag tag = payload.readNbt();
            assert (tag != null);
            map.put(id, (Object)tag);
        }
        looper.execute(() -> ClientMessages.lambda$onUpdateNetwork$3(player, (Int2ObjectMap)map, type));
    }

    private static void onDeleteNetwork(FriendlyByteBuf payload, Supplier<LocalPlayer> player, BlockableEventLoop<?> looper) {
        int id = payload.readInt();
        looper.execute(() -> {
            LocalPlayer p = (LocalPlayer)player.get();
            if (p == null) {
                return;
            }
            ClientCache.deleteNetwork(id);
            AbstractContainerMenu patt0$temp = p.containerMenu;
            if (patt0$temp instanceof FluxMenu) {
                FluxMenu m = (FluxMenu)patt0$temp;
                if (m.mOnResultListener != null) {
                    m.mOnResultListener.onResult(m, 2, 0);
                }
            }
        });
    }

    private static void onUpdateConnections(FriendlyByteBuf payload, Supplier<LocalPlayer> player, BlockableEventLoop<?> looper) {
        int id = payload.readInt();
        int size = payload.readVarInt();
        ArrayList<CompoundTag> tags = new ArrayList<CompoundTag>();
        for (int i = 0; i < size; ++i) {
            tags.add(payload.readNbt());
        }
        looper.execute(() -> {
            LocalPlayer p = (LocalPlayer)player.get();
            if (p == null) {
                return;
            }
            ClientCache.updateConnections(id, tags);
            AbstractContainerMenu patt0$temp = p.containerMenu;
            if (patt0$temp instanceof FluxMenu) {
                FluxMenu m = (FluxMenu)patt0$temp;
                if (m.mOnResultListener != null) {
                    m.mOnResultListener.onResult(m, 9, 0);
                }
            }
        });
    }

    private static /* synthetic */ void lambda$onUpdateNetwork$3(Supplier player, Int2ObjectMap map, byte type) {
        LocalPlayer p = (LocalPlayer)player.get();
        if (p == null) {
            return;
        }
        ClientCache.updateNetwork((Int2ObjectMap<CompoundTag>)map, type);
        AbstractContainerMenu patt0$temp = p.containerMenu;
        if (patt0$temp instanceof FluxMenu) {
            FluxMenu m = (FluxMenu)patt0$temp;
            if (m.mOnResultListener != null) {
                m.mOnResultListener.onResult(m, 8, 0);
            }
        }
    }
}

