/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.config.screen;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.config.ConfigOption;
import terrails.colorfulhearts.config.ConfigUtils;
import terrails.colorfulhearts.config.Configuration;
import terrails.colorfulhearts.config.SimpleConfigOption;
import terrails.colorfulhearts.config.screen.HeartType;
import terrails.colorfulhearts.config.screen.base.ScrollableWidgetList;
import terrails.colorfulhearts.config.screen.widgets.HeartColorEditBox;
import terrails.colorfulhearts.render.HeartRenderer;
import terrails.colorfulhearts.render.TabHeartRenderer;

public class ColorSelectionScreen
extends Screen {
    private final Screen lastScreen;
    private List<HeartColorEditBox> editBoxes;
    private List<Button> heartTypeButtons;
    private Button saveButton;
    private boolean vanillaHeart;
    private boolean hasChanged;
    private boolean colorsChanged;
    private boolean vanillaChanged;
    private ScrollableWidgetList colorSelectionList;
    private HeartType heartType;

    public ColorSelectionScreen(Screen lastScreen, boolean health) {
        super((Component)Component.translatable((String)(health ? "colorfulhearts.screen.health.title" : "colorfulhearts.screen.absorption.title")));
        this.lastScreen = lastScreen;
        this.heartType = health ? HeartType.HEALTH : HeartType.ABSORBING;
        this.updateHeartType(this.heartType, false);
    }

    public void tick() {
        if (this.hasChanged) {
            this.heartTypeButtons.forEach(btn -> {
                btn.active = false;
            });
            this.saveButton.active = this.canApplyChanges();
        } else if (this.saveButton.active) {
            this.rebuildWidgets();
        }
    }

    protected void init() {
        super.init();
        this.colorsChanged = false;
        int width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        int marginY = 32;
        double prevScrollAmount = this.colorSelectionList == null ? 0.0 : this.colorSelectionList.getScrollAmount();
        this.colorSelectionList = (ScrollableWidgetList)this.addRenderableWidget((GuiEventListener)new ScrollableWidgetList(Minecraft.getInstance(), width, height - marginY * 2, marginY, 26));
        this.addColorElements();
        this.colorSelectionList.setScrollAmount(prevScrollAmount);
        int BUTTON_SPACING = 10;
        int BUTTON_WIDTH = 80;
        int BUTTON_HEIGHT = 20;
        int startX = (width - BUTTON_WIDTH * 4 - BUTTON_SPACING * 3) / 2;
        int y = (marginY - 20) / 2;
        Button normalHearts = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"colorfulhearts.options.button.hearttype.normal"), btn -> this.updateHeartType(this.heartType.isHealthType() ? HeartType.HEALTH : HeartType.ABSORBING, true)).pos(startX, y).size(BUTTON_WIDTH, BUTTON_HEIGHT).build());
        normalHearts.active = this.heartType != HeartType.HEALTH && this.heartType != HeartType.ABSORBING;
        int x = startX + BUTTON_WIDTH + BUTTON_SPACING;
        Button poisonedHearts = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"colorfulhearts.options.button.hearttype.poisoned"), btn -> this.updateHeartType(this.heartType.isHealthType() ? HeartType.HEALTH_POISONED : HeartType.ABSORBING_POISONED, true)).pos(x, y).size(BUTTON_WIDTH, BUTTON_HEIGHT).build());
        poisonedHearts.active = this.heartType != HeartType.HEALTH_POISONED && this.heartType != HeartType.ABSORBING_POISONED;
        Button witheredHearts = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"colorfulhearts.options.button.hearttype.withered"), btn -> this.updateHeartType(this.heartType.isHealthType() ? HeartType.HEALTH_WITHERED : HeartType.ABSORBING_WITHERED, true)).pos(x += BUTTON_WIDTH + BUTTON_SPACING, y).size(BUTTON_WIDTH, BUTTON_HEIGHT).build());
        witheredHearts.active = this.heartType != HeartType.HEALTH_WITHERED && this.heartType != HeartType.ABSORBING_WITHERED;
        Button frozenHearts = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"colorfulhearts.options.button.hearttype.frozen"), btn -> this.updateHeartType(this.heartType.isHealthType() ? HeartType.HEALTH_FROZEN : HeartType.ABSORBING_FROZEN, true)).pos(x += BUTTON_WIDTH + BUTTON_SPACING, y).size(BUTTON_WIDTH, BUTTON_HEIGHT).build());
        frozenHearts.active = this.heartType != HeartType.HEALTH_FROZEN && this.heartType != HeartType.ABSORBING_FROZEN;
        this.heartTypeButtons = List.of(normalHearts, poisonedHearts, witheredHearts, frozenHearts);
        BUTTON_WIDTH = 120;
        BUTTON_SPACING = 30;
        startX = (width - BUTTON_WIDTH * 2 - BUTTON_SPACING) / 2;
        y = height - BUTTON_HEIGHT / 2 - marginY / 2;
        this.saveButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"colorfulhearts.options.button.confirmsave"), btn -> {
            this.saveConfig();
            this.onClose();
        }).pos(startX, y).size(BUTTON_WIDTH, BUTTON_HEIGHT).build());
        this.saveButton.active = false;
        x = startX + BUTTON_WIDTH + BUTTON_SPACING;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"colorfulhearts.options.button.cancel"), btn -> this.onClose()).pos(x, y).size(BUTTON_WIDTH, BUTTON_HEIGHT).build());
        if (this.hasChanged) {
            this.heartTypeButtons.forEach(btn -> {
                btn.active = false;
            });
        }
        if (this.canApplyChanges()) {
            this.saveButton.active = true;
        }
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.lastScreen);
        if (this.colorsChanged) {
            this.minecraft.reloadResourcePacks();
            ConfigUtils.loadColoredHearts();
            ConfigUtils.loadStatusEffectHearts();
            HeartRenderer.INSTANCE.lastHealth = 0;
            TabHeartRenderer.INSTANCE.lastHealth = 0;
            CColorfulHearts.PROXY.heartUpdateEvent();
        } else if (this.vanillaChanged) {
            ConfigUtils.loadColoredHearts();
            ConfigUtils.loadStatusEffectHearts();
            HeartRenderer.INSTANCE.lastHealth = 0;
            TabHeartRenderer.INSTANCE.lastHealth = 0;
            CColorfulHearts.PROXY.heartUpdateEvent();
        }
    }

    public void updateHeartType(HeartType type, boolean rebuildWidgets) {
        this.heartType = type;
        this.editBoxes = null;
        boolean bl = this.vanillaHeart = this.hasVanillaVariant() && type.isVanillaVariantPresent();
        if (rebuildWidgets) {
            this.rebuildWidgets();
        }
    }

    public boolean hasVanillaVariant() {
        return this.heartType.isHealthType() || this.heartType == HeartType.ABSORBING;
    }

    private void addColorElements() {
        int ELEMENTS_PER_ROW = 4;
        int ELEMENT_SPACING = 6;
        int EDIT_BOX_WIDTH = 60;
        int BUTTON_DIMS = 20;
        int BUTTON_SPACING = 3;
        int screenWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int totalElementWidth = 350;
        int startX = (screenWidth - totalElementWidth) / 2;
        ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
        int OFFSET = 0;
        if (this.hasVanillaVariant()) {
            OFFSET = 1;
            Supplier<Component> componentSupplier = () -> Component.translatable((String)(this.vanillaHeart ? "colorfulhearts.options.button.vanillaheart.true" : "colorfulhearts.options.button.vanillaheart.false"));
            widgets.add((AbstractWidget)Button.builder((Component)componentSupplier.get(), btn -> {
                this.vanillaHeart = !this.vanillaHeart;
                this.hasChanged = this.haveValuesChanged();
                btn.setMessage((Component)componentSupplier.get());
                this.rebuildWidgets();
            }).pos(startX, 0).size(83, 20).build());
        }
        if (this.editBoxes == null) {
            this.editBoxes = new LinkedList<HeartColorEditBox>();
            for (String color : this.heartType.getConfigOption().getRaw()) {
                HeartColorEditBox box = new HeartColorEditBox(this.font, 0, 0, 0, 0, this.heartType);
                box.setValue(color);
                this.editBoxes.add(box);
            }
        }
        int elementCount = this.editBoxes.size();
        for (int i = 0; i < elementCount; ++i) {
            boolean canAddMoreHearts;
            boolean stop;
            boolean bl = stop = this.heartType.isHealthType() && this.heartType != HeartType.HEALTH && (i > 0 && this.vanillaHeart || i > 1);
            if (stop) {
                this.colorSelectionList.addEntry(new ScrollableWidgetList.Entry(widgets));
                break;
            }
            int column = (i + OFFSET) % 4;
            int x = startX + column * 89;
            int i_ = i;
            Button button = Button.builder((Component)Component.literal((String)"-").withStyle(ChatFormatting.RED), btn -> {
                this.editBoxes.remove(i_);
                this.hasChanged = this.haveValuesChanged();
                this.rebuildWidgets();
            }).pos(x, 0).size(20, 20).build();
            HeartColorEditBox box = this.editBoxes.get(i);
            box = new HeartColorEditBox(this.font, x + 20 + 3, 0, 58, 20, box, this.heartType);
            box.setResponder(str -> {
                this.hasChanged = this.haveValuesChanged();
            });
            this.editBoxes.set(i, box);
            widgets.add((AbstractWidget)button);
            widgets.add((AbstractWidget)box);
            if (column + 1 == 4) {
                this.colorSelectionList.addEntry(new ScrollableWidgetList.Entry(widgets));
                widgets.clear();
            }
            if (i + 1 != elementCount) continue;
            boolean bl2 = canAddMoreHearts = !this.heartType.isEffectType() || !this.hasEnoughColors();
            if (canAddMoreHearts) {
                column = (column + 1) % 4;
                x = startX + column * 89;
                Button addButton = Button.builder((Component)Component.literal((String)"+").withStyle(ChatFormatting.GREEN), btn -> {
                    this.editBoxes.add(new HeartColorEditBox(this.font, 0, 0, 38, 20, this.heartType));
                    this.hasChanged = this.haveValuesChanged();
                    this.rebuildWidgets();
                }).pos(x, 0).size(20, 20).build();
                widgets.add((AbstractWidget)addButton);
            }
            this.colorSelectionList.addEntry(new ScrollableWidgetList.Entry(widgets));
        }
        if (this.editBoxes.isEmpty()) {
            int x = startX + 60 + 20 + 6 + 3;
            Button addButton = Button.builder((Component)Component.literal((String)"+").withStyle(ChatFormatting.GREEN), btn -> {
                this.editBoxes.add(new HeartColorEditBox(this.font, 0, 0, 38, 20, this.heartType));
                this.rebuildWidgets();
            }).pos(x, 0).size(20, 20).build();
            widgets.add((AbstractWidget)addButton);
            this.colorSelectionList.addEntry(new ScrollableWidgetList.Entry(widgets));
        }
    }

    public boolean hasEnoughColors() {
        int count = this.editBoxes.size();
        return count > 0 && this.heartType.isHealthType() && (this.heartType == HeartType.HEALTH || this.vanillaHeart || count == 2) || !this.heartType.isHealthType() && (this.heartType == HeartType.ABSORBING || count == 2);
    }

    public boolean canApplyChanges() {
        if (this.editBoxes.stream().anyMatch(HeartColorEditBox::isInvalid)) {
            return false;
        }
        return this.hasChanged && this.hasEnoughColors();
    }

    private boolean haveValuesChanged() {
        if (this.editBoxes.stream().anyMatch(HeartColorEditBox::isInvalid)) {
            return true;
        }
        if (this.vanillaHeart != this.heartType.isVanillaVariantPresent()) {
            return true;
        }
        List<Integer> currentColors = this.heartType.getColors();
        List<Integer> newColors = this.editBoxes.stream().map(HeartColorEditBox::getColor).toList();
        if (currentColors.size() != newColors.size()) {
            return true;
        }
        for (int i = 0; i < currentColors.size(); ++i) {
            if (Objects.equals(currentColors.get(i), newColors.get(i))) continue;
            return true;
        }
        return false;
    }

    private SimpleConfigOption<Boolean> getConfigVanilla() {
        return switch (this.heartType) {
            case HeartType.HEALTH -> Configuration.HEALTH.vanillaHearts;
            case HeartType.ABSORBING -> Configuration.ABSORPTION.vanillaHearts;
            default -> null;
        };
    }

    private void saveConfig() {
        SimpleConfigOption<Boolean> configVanilla = this.getConfigVanilla();
        if (configVanilla != null && this.vanillaHeart != configVanilla.get()) {
            configVanilla.set(this.vanillaHeart);
            this.vanillaChanged = true;
        }
        ConfigOption<List<String>, List<Integer>> configColors = this.heartType.getConfigOption();
        List<Integer> currentColors = configColors.get();
        List<Integer> newColors = this.editBoxes.stream().map(HeartColorEditBox::getColor).toList();
        if (currentColors.size() != newColors.size()) {
            configColors.set(newColors);
            this.colorsChanged = true;
        } else {
            for (int i = 0; i < currentColors.size(); ++i) {
                if (Objects.equals(currentColors.get(i), newColors.get(i))) continue;
                configColors.set(newColors);
                this.colorsChanged = true;
                break;
            }
        }
        CColorfulHearts.PROXY.applyConfig();
    }
}

