/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.cobblegengalore.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.cobblegengalore.CobbleGenGalore;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockGenRecipe
implements Recipe<RecipeInput> {
    public ItemStack result;
    public final BlockState left;
    public final BlockState right;
    public final BlockState modifier;
    public final float speed;
    public final boolean consumeLeft;
    public final boolean consumeRight;

    public BlockGenRecipe(ItemStack result, BlockState left, BlockState right, BlockState modifier, float speed, boolean consumeLeft, boolean consumeRight) {
        this.result = result;
        this.left = left;
        this.right = right;
        this.modifier = modifier;
        this.speed = speed;
        this.consumeLeft = consumeLeft;
        this.consumeRight = consumeRight;
    }

    public boolean matches(RecipeInput inv, Level worldIn) {
        return false;
    }

    public boolean matches(BlockState first, BlockState second, BlockState below) {
        boolean validModifierBlock = this.modifier.isAir() || this.modifier.is(below.getBlock());
        return !(!validModifierBlock || (!this.left.isAir() && !this.left.is(first.getBlock()) || !this.right.isAir() && !this.right.is(second.getBlock())) && (!this.right.isAir() && !this.right.is(first.getBlock()) || !this.left.isAir() && !this.left.is(second.getBlock())));
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.result.copy();
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)CobbleGenGalore.BLOCKGEN_RECIPE_SERIALIZER.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)CobbleGenGalore.BLOCKGEN_RECIPE_TYPE.get();
    }

    private static BlockState readBlockState(@Nullable CompoundTag tag) {
        if (tag == null) {
            return Blocks.AIR.defaultBlockState();
        }
        ResourceLocation resourcelocation = ResourceLocation.parse((String)tag.getString("Name"));
        Block block = (Block)BuiltInRegistries.BLOCK.get(resourcelocation);
        BlockState blockstate = block.defaultBlockState();
        if (tag.contains("Properties", 10)) {
            CompoundTag compoundtag = tag.getCompound("Properties");
            StateDefinition statedefinition = block.getStateDefinition();
            for (String propertyName : compoundtag.getAllKeys()) {
                Property property = statedefinition.getProperty(propertyName);
                if (property == null) continue;
                blockstate = BlockGenRecipe.setValueHelper(blockstate, property, propertyName, compoundtag, tag);
            }
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState setValueHelper(BlockState blockState, Property<T> property, String propertyName, CompoundTag tag, CompoundTag stateTag) {
        Optional optional = property.getValue(tag.getString(propertyName));
        if (optional.isPresent()) {
            return (BlockState)blockState.setValue(property, (Comparable)optional.get());
        }
        CobbleGenGalore.LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", new Object[]{propertyName, tag.getString(propertyName), stateTag.toString()});
        return blockState;
    }

    public static class Serializer
    implements RecipeSerializer<BlockGenRecipe> {
        private static final MapCodec<BlockGenRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.CODEC.fieldOf("result").orElse((Object)ItemStack.EMPTY).forGetter(recipe -> recipe.result), (App)BlockState.CODEC.fieldOf("left").orElse((Object)Blocks.AIR.defaultBlockState()).forGetter(recipe -> recipe.left), (App)BlockState.CODEC.fieldOf("right").orElse((Object)Blocks.AIR.defaultBlockState()).forGetter(recipe -> recipe.right), (App)BlockState.CODEC.fieldOf("modifier").orElse((Object)Blocks.AIR.defaultBlockState()).forGetter(recipe -> recipe.modifier), (App)Codec.FLOAT.fieldOf("speed").orElse((Object)Float.valueOf(1.0f)).forGetter(recipe -> Float.valueOf(recipe.speed)), (App)Codec.BOOL.fieldOf("consumeLeft").orElse((Object)false).forGetter(recipe -> recipe.consumeLeft), (App)Codec.BOOL.fieldOf("consumeRight").orElse((Object)false).forGetter(recipe -> recipe.consumeRight)).apply((Applicative)builder, BlockGenRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BlockGenRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BlockGenRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BlockGenRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static BlockGenRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
                BlockState left = BlockGenRecipe.readBlockState(buffer.readNbt());
                BlockState right = BlockGenRecipe.readBlockState(buffer.readNbt());
                BlockState modifier = BlockGenRecipe.readBlockState(buffer.readNbt());
                return new BlockGenRecipe(result, left, right, modifier, buffer.readFloat(), buffer.readBoolean(), buffer.readBoolean());
            }
            catch (Exception e) {
                CobbleGenGalore.LOGGER.error("Error reading blockgen recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, BlockGenRecipe recipe) {
            try {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
                buffer.writeNbt((Tag)NbtUtils.writeBlockState((BlockState)recipe.left));
                buffer.writeNbt((Tag)NbtUtils.writeBlockState((BlockState)recipe.right));
                buffer.writeNbt((Tag)NbtUtils.writeBlockState((BlockState)recipe.modifier));
                buffer.writeFloat(recipe.speed);
                buffer.writeBoolean(recipe.consumeLeft);
                buffer.writeBoolean(recipe.consumeRight);
            }
            catch (Exception e) {
                CobbleGenGalore.LOGGER.error("Error writing blockgen recipe to packet. ", (Throwable)e);
                throw e;
            }
        }
    }
}

