/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.common.items;

import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.security.IActionHost;
import appeng.api.parts.IPart;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.me.InWorldGridNode;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.menu.MenuOpener;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import com.glodblock.github.ae2netanalyser.common.AEASingletons;
import com.glodblock.github.ae2netanalyser.common.inventory.DummyItemInventory;
import com.glodblock.github.ae2netanalyser.common.me.AnalyserMode;
import com.glodblock.github.ae2netanalyser.common.me.NetworkData;
import com.glodblock.github.ae2netanalyser.common.me.netdata.FlagType;
import com.glodblock.github.ae2netanalyser.common.me.netdata.LinkFlag;
import com.glodblock.github.ae2netanalyser.common.me.netdata.NodeFlag;
import com.glodblock.github.ae2netanalyser.common.me.netdata.State;
import com.glodblock.github.ae2netanalyser.common.me.tracker.PlayerTracker;
import com.glodblock.github.ae2netanalyser.container.ContainerAnalyser;
import com.glodblock.github.ae2netanalyser.network.AEANetworkHandler;
import com.glodblock.github.ae2netanalyser.network.packets.SNetworkDataUpdate;
import com.glodblock.github.glodium.client.render.ColorData;
import com.glodblock.github.glodium.util.GlodCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemNetworkAnalyzer
extends Item
implements IMenuItem {
    public static final Reference2ObjectMap<Enum<?>, ColorData> defaultColors = new Reference2ObjectOpenHashMap();
    public static final AnalyserConfig defaultConfig;

    public ItemNetworkAnalyzer() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player p, @NotNull InteractionHand hand) {
        if (!level.isClientSide() && !p.isShiftKeyDown()) {
            MenuOpener.open(ContainerAnalyser.TYPE, (Player)p, (MenuHostLocator)MenuLocators.forHand((Player)p, (InteractionHand)hand));
        }
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)p.getItemInHand(hand));
    }

    @NotNull
    public InteractionResult useOn(@Nonnull UseOnContext context) {
        ServerPlayer player;
        ItemStack tool;
        Player player2;
        if (!context.getLevel().isClientSide && (player2 = context.getPlayer()) instanceof ServerPlayer && (tool = (player = (ServerPlayer)player2).getMainHandItem()).getItem() == AEASingletons.ANALYSER) {
            tool.set(AEASingletons.GLOBAL_POS, (Object)GlobalPos.of((ResourceKey)context.getLevel().dimension(), (BlockPos)context.getClickedPos()));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int slot, boolean selected) {
        IInWorldGridNodeHost host;
        GlobalPos pos;
        ServerPlayer player;
        if (!world.isClientSide && entity instanceof ServerPlayer && stack == (player = (ServerPlayer)entity).getMainHandItem() && player.getMainHandItem().getItem() == AEASingletons.ANALYSER && (pos = (GlobalPos)stack.get(AEASingletons.GLOBAL_POS)) != null && pos.dimension().equals(world.dimension()) && PlayerTracker.needUpdate((Player)player, pos) && (host = GridHelper.getNodeHost((Level)world, (BlockPos)pos.pos())) != null) {
            IGridNode node = host.getGridNode(null);
            if (node == null && host instanceof IGridConnectedBlockEntity) {
                IGridConnectedBlockEntity gct = (IGridConnectedBlockEntity)host;
                node = gct.getGridNode();
            }
            if (node != null) {
                ObjectOpenHashSet connections = new ObjectOpenHashSet();
                Set<NetworkData.ANode> nodes = this.extractNodes(node.getGrid(), (Set<IGridConnection>)connections, world);
                ObjectOpenHashSet links = new ObjectOpenHashSet();
                for (IGridConnection c : connections) {
                    NetworkData.ANode a = this.wrapGridNode(c.a());
                    NetworkData.ANode b = this.wrapGridNode(c.b());
                    if (a == null || b == null || Objects.equals(a, b)) continue;
                    State<LinkFlag> state = new State<LinkFlag>(LinkFlag.NORMAL);
                    if (c.a().hasFlag(GridFlags.DENSE_CAPACITY) && c.b().hasFlag(GridFlags.DENSE_CAPACITY)) {
                        state.set(LinkFlag.DENSE);
                    }
                    if (c.a().hasFlag(GridFlags.CANNOT_CARRY_COMPRESSED) && c.b().hasFlag(GridFlags.CANNOT_CARRY_COMPRESSED)) {
                        state.set(LinkFlag.COMPRESSED);
                    }
                    links.add((Object)new NetworkData.ALink(a, b, (short)c.getUsedChannels(), state));
                }
                AEANetworkHandler.INSTANCE.sendTo(new SNetworkDataUpdate(new NetworkData(nodes.toArray(new NetworkData.ANode[0]), (NetworkData.ALink[])links.toArray((Object[])new NetworkData.ALink[0]))), player);
            }
        }
    }

    private Set<NetworkData.ANode> extractNodes(IGrid grid, Set<IGridConnection> connections, Level world) {
        if (grid != null) {
            ObjectOpenHashSet nodes = new ObjectOpenHashSet();
            for (IGridNode node : grid.getNodes()) {
                NetworkData.ANode a;
                ResourceKey dim = node.getLevel().dimension();
                if (!dim.equals(world.dimension()) || (a = this.wrapGridNode(node)) == null) continue;
                connections.addAll(node.getConnections());
                nodes.add((Object)this.wrapGridNode(node));
            }
            return nodes;
        }
        return Set.of();
    }

    @Nullable
    private NetworkData.ANode wrapGridNode(IGridNode node) {
        if (node instanceof InWorldGridNode) {
            InWorldGridNode worldNode = (InWorldGridNode)node;
            BlockPos pos = worldNode.getLocation();
            State<NodeFlag> state = new State<NodeFlag>(NodeFlag.NORMAL);
            if (!this.checkChannel(worldNode)) {
                state.set(NodeFlag.MISSING);
            }
            if (node.hasFlag(GridFlags.DENSE_CAPACITY)) {
                state.set(NodeFlag.DENSE);
            }
            return new NetworkData.ANode(pos, state);
        }
        return null;
    }

    private boolean checkChannel(@NotNull InWorldGridNode node) {
        BlockPos pos;
        ServerLevel world = node.getLevel();
        BlockEntity tile = world.getBlockEntity(pos = node.getLocation());
        if (tile instanceof CableBusBlockEntity) {
            CableBusBlockEntity cable = (CableBusBlockEntity)tile;
            for (Direction face : Direction.values()) {
                IActionHost host;
                IPart part = cable.getPart(face);
                if (!(part instanceof IActionHost) || (host = (IActionHost)part).getActionableNode() == null || host.getActionableNode().isOnline()) continue;
                return false;
            }
            return true;
        }
        return node.isOnline();
    }

    @Nullable
    public ItemMenuHost<ItemNetworkAnalyzer> getMenuHost(Player player, ItemMenuHostLocator locator, @Nullable BlockHitResult hitResult) {
        return new DummyItemInventory(this, player, locator);
    }

    static {
        defaultColors.put((Object)NodeFlag.NORMAL, (Object)new ColorData(0.8f, 0.0f, 0.0f, 1.0f));
        defaultColors.put((Object)NodeFlag.DENSE, (Object)new ColorData(0.8f, 1.0f, 1.0f, 0.0f));
        defaultColors.put((Object)NodeFlag.MISSING, (Object)new ColorData(0.8f, 1.0f, 0.0f, 0.0f));
        defaultColors.put((Object)LinkFlag.NORMAL, (Object)new ColorData(0.8f, 0.0f, 0.0f, 1.0f));
        defaultColors.put((Object)LinkFlag.DENSE, (Object)new ColorData(0.8f, 1.0f, 1.0f, 0.0f));
        defaultColors.put((Object)LinkFlag.COMPRESSED, (Object)new ColorData(0.8f, 1.0f, 0.0f, 1.0f));
        defaultConfig = new AnalyserConfig(AnalyserMode.FULL, 0.4f, (Map<Enum<?>, ColorData>)defaultColors);
    }

    public record AnalyserConfig(AnalyserMode mode, float nodeSize, Map<Enum<?>, ColorData> colors) {
        public static final Codec<AnalyserConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)AnalyserMode.CODEC.fieldOf("analyzer_mode").forGetter(a -> a.mode), (App)Codec.FLOAT.fieldOf("node_size").forGetter(a -> Float.valueOf(a.nodeSize)), (App)GlodCodecs.map(FlagType.CODEC, (Codec)ColorData.CODEC).fieldOf("color_map").forGetter(a -> a.colors)).apply((Applicative)builder, AnalyserConfig::new));
        public static final StreamCodec<FriendlyByteBuf, AnalyserConfig> STREAM_CODEC = StreamCodec.of((buf, config) -> config.writeToBytes((FriendlyByteBuf)buf), AnalyserConfig::readFromBytes);

        public void writeToBytes(FriendlyByteBuf buf) {
            buf.writeByte(this.mode.ordinal());
            buf.writeFloat(this.nodeSize);
            buf.writeByte(this.colors.size());
            for (Map.Entry<Enum<?>, ColorData> entry : this.colors.entrySet()) {
                Enum<?> type = entry.getKey();
                ColorData color = entry.getValue();
                if (type.getClass() == LinkFlag.class) {
                    buf.writeByte(FlagType.LINK.ordinal());
                    buf.writeByte(type.ordinal());
                    buf.writeInt(color.toARGB());
                }
                if (type.getClass() != NodeFlag.class) continue;
                buf.writeByte(FlagType.NODE.ordinal());
                buf.writeByte(type.ordinal());
                buf.writeInt(color.toARGB());
            }
        }

        public static AnalyserConfig readFromBytes(FriendlyByteBuf buf) {
            AnalyserMode mode = AnalyserMode.byIndex(buf.readByte());
            float node_size = buf.readFloat();
            Reference2ObjectOpenHashMap colors = new Reference2ObjectOpenHashMap();
            int size = buf.readByte();
            block4: for (int i = 0; i < size; ++i) {
                FlagType type = FlagType.byIndex(buf.readByte());
                byte name = buf.readByte();
                ColorData color = new ColorData(buf.readInt());
                switch (type) {
                    case LINK: {
                        colors.put((Object)LinkFlag.byIndex(name), (Object)color);
                        continue block4;
                    }
                    case NODE: {
                        colors.put((Object)NodeFlag.byIndex(name), (Object)color);
                    }
                }
            }
            return new AnalyserConfig(mode, node_size, (Map<Enum<?>, ColorData>)colors);
        }
    }
}

