/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.items;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.xalcon.torchmaster.ModRegistry;

public class FrozenPearlItem
extends Item {
    public FrozenPearlItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStack);
        }
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(0, 0, 0);
        BlockPos pos = player.blockPosition();
        level.playSound(player, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 0.7f, 0.6f);
        for (int x = -15; x <= 15; ++x) {
            for (int y = -15; y <= 15; ++y) {
                for (int z = -15; z <= 15; ++z) {
                    checkPos.set(pos.getX() + x, pos.getY() + y, pos.getZ() + z);
                    Block block = level.getBlockState((BlockPos)checkPos).getBlock();
                    if (block != ModRegistry.blockInvisibleLight.get()) continue;
                    level.removeBlock((BlockPos)checkPos, false);
                    if (!itemStack.isEmpty()) continue;
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)ItemStack.EMPTY);
                }
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId(stack) + ".tooltip")));
    }
}

