/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.util.PanelPositioning;
import dev.ftb.mods.ftbultimine.CooldownTracker;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.FTBUltimineCommon;
import dev.ftb.mods.ftbultimine.api.util.CanUltimineResult;
import dev.ftb.mods.ftbultimine.client.CachedEdge;
import dev.ftb.mods.ftbultimine.client.ClientPlatformUtil;
import dev.ftb.mods.ftbultimine.client.UltimineRenderTypes;
import dev.ftb.mods.ftbultimine.config.FTBUltimineClientConfig;
import dev.ftb.mods.ftbultimine.event.LevelRenderLastEvent;
import dev.ftb.mods.ftbultimine.net.KeyPressedPacket;
import dev.ftb.mods.ftbultimine.net.ModeChangedPacket;
import dev.ftb.mods.ftbultimine.shape.ShapeRegistry;
import dev.ftb.mods.ftbultimine.utils.ShapeMerger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;

public class FTBUltimineClient
extends FTBUltimineCommon {
    public static KeyMapping keyBindUltimine;
    public static KeyMapping keyBindNextMode;
    public static KeyMapping keyBindPrevMode;
    private boolean pressed;
    private boolean canUltimine;
    private CanUltimineResult canUltimineStatus;
    private List<BlockPos> shapeBlocks = Collections.emptyList();
    private int actualBlocks = 0;
    private List<CachedEdge> cachedEdges = null;
    private BlockPos cachedPos = null;
    public boolean hasScrolledYet = false;
    private long lastToggle = 0L;
    public final int INPUT_DELAY = 125;
    private int shapeIdx = 0;
    private int maxPanelWidth = 100;
    private List<IndentedLine> infoPanelList = List.of();

    public FTBUltimineClient() {
        keyBindUltimine = new KeyMapping("key.ftbultimine", InputConstants.Type.KEYSYM, 96, "key.categories.ftbultimine");
        KeyMappingRegistry.register((KeyMapping)keyBindUltimine);
        keyBindNextMode = new KeyMapping("ftbultimine.change_shape.next", InputConstants.Type.KEYSYM, 265, "key.categories.ftbultimine");
        KeyMappingRegistry.register((KeyMapping)keyBindNextMode);
        keyBindPrevMode = new KeyMapping("ftbultimine.change_shape.prev", InputConstants.Type.KEYSYM, 264, "key.categories.ftbultimine");
        KeyMappingRegistry.register((KeyMapping)keyBindPrevMode);
        ClientTickEvent.CLIENT_PRE.register(this::clientTick);
        ClientGuiEvent.RENDER_HUD.register(this::renderGameOverlay);
        LevelRenderLastEvent.EVENT.register(this::renderInGame);
        ClientRawInputEvent.MOUSE_SCROLLED.register(this::onMouseScrolled);
        ClientRawInputEvent.KEY_PRESSED.register(this::onKeyPress);
    }

    public static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    @Override
    public void setShape(int shapeIdx, List<BlockPos> blocks) {
        this.shapeIdx = shapeIdx;
        if (blocks != null) {
            this.actualBlocks = blocks.size();
            int maxRendered = Math.min(this.actualBlocks, (Integer)FTBUltimineClientConfig.RENDER_OUTLINE.get());
            this.shapeBlocks = blocks.subList(0, maxRendered);
            this.cachedEdges = null;
            this.updateEdges();
        }
        if (!this.pressed && ((Boolean)FTBUltimineClientConfig.SHAPE_FEEDBACK_MESSAGE.get()).booleanValue()) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"key.ftbultimine").append(" : ").append((Component)ShapeRegistry.INSTANCE.getShape(shapeIdx).getDisplayName()), true);
        }
    }

    public void renderInGame(PoseStack stack) {
        if (!this.pressed || this.cachedPos == null || this.cachedEdges == null || this.cachedEdges.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (!this.canUltimine) {
            return;
        }
        Camera activeRenderInfo = mc.getEntityRenderDispatcher().camera;
        Vec3 projectedView = activeRenderInfo.getPosition();
        stack.pushPose();
        stack.translate((double)this.cachedPos.getX() - projectedView.x, (double)this.cachedPos.getY() - projectedView.y, (double)this.cachedPos.getZ() - projectedView.z);
        Matrix4f matrix = stack.last().pose();
        VertexConsumer buffer = mc.renderBuffers().bufferSource().getBuffer(UltimineRenderTypes.LINES_NORMAL);
        for (CachedEdge edge : this.cachedEdges) {
            buffer.addVertex(matrix, edge.x1, edge.y1, edge.z1).setColor(255, 255, 255, 255);
            buffer.addVertex(matrix, edge.x2, edge.y2, edge.z2).setColor(255, 255, 255, 255);
        }
        mc.renderBuffers().bufferSource().endBatch(UltimineRenderTypes.LINES_NORMAL);
        VertexConsumer buffer2 = mc.renderBuffers().bufferSource().getBuffer(UltimineRenderTypes.LINES_TRANSPARENT);
        int alpha = (Integer)FTBUltimineClientConfig.PREVIEW_LINE_ALPHA.get();
        for (CachedEdge edge : this.cachedEdges) {
            buffer2.addVertex(matrix, edge.x1, edge.y1, edge.z1).setColor(255, 255, 255, alpha);
            buffer2.addVertex(matrix, edge.x2, edge.y2, edge.z2).setColor(255, 255, 255, alpha);
        }
        mc.renderBuffers().bufferSource().endBatch(UltimineRenderTypes.LINES_TRANSPARENT);
        stack.popPose();
    }

    public EventResult onMouseScrolled(Minecraft client, double amountX, double amountY) {
        if (this.pressed && (amountY != 0.0 || amountX != 0.0) && this.isMenuSneaking()) {
            NetworkManager.sendToServer((CustomPacketPayload)new ModeChangedPacket(amountX < 0.0 || amountY < 0.0));
            this.hasScrolledYet = true;
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult onKeyPress(Minecraft client, int keyCode, int scanCode, int action, int modifiers) {
        boolean nextMode;
        if (System.currentTimeMillis() - this.lastToggle < 125L) {
            return EventResult.pass();
        }
        if (ClientPlatformUtil.doesKeybindMatch(keyBindPrevMode, keyCode, scanCode, modifiers)) {
            nextMode = false;
        } else if (ClientPlatformUtil.doesKeybindMatch(keyBindNextMode, keyCode, scanCode, modifiers)) {
            nextMode = true;
        } else {
            return EventResult.pass();
        }
        if ((this.pressed || !((Boolean)FTBUltimineClientConfig.REQUIRE_ULTIMINE_KEY_FOR_CYCLING.get()).booleanValue()) && this.isMenuSneaking()) {
            NetworkManager.sendToServer((CustomPacketPayload)new ModeChangedPacket(nextMode));
            this.lastToggle = System.currentTimeMillis();
            this.hasScrolledYet = true;
        }
        return EventResult.pass();
    }

    private boolean isMenuSneaking() {
        if (!((Boolean)FTBUltimineClientConfig.REQUIRE_SNEAK_FOR_MENU.get()).booleanValue()) {
            return true;
        }
        return keyBindUltimine.matches(340, 0) || keyBindUltimine.matches(344, 0) ? Screen.hasControlDown() : Screen.hasShiftDown();
    }

    private List<IndentedLine> addPressedInfo() {
        int i;
        MutableComponent msg;
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean isActive = true;
        if (CooldownTracker.isOnCooldown(FTBUltimineClient.getClientPlayer())) {
            msg = Component.translatable((String)"ftbultimine.info.cooldown").withStyle(style -> style.withColor(TextColor.fromRgb((int)12566380)));
        } else if (this.canUltimine && this.actualBlocks > 0) {
            msg = Component.translatable((String)"ftbultimine.info.active").withStyle(style -> style.withColor(TextColor.fromRgb((int)10731148)));
        } else {
            msg = Component.translatable((String)"ftbultimine.info.not_active").withStyle(style -> style.withColor(TextColor.fromRgb((int)12542314)));
            isActive = false;
        }
        builder.add((Object)new IndentedLine(0, (Component)Component.translatable((String)"ftbultimine.info.base", (Object[])new Object[]{msg})));
        if (!isActive) {
            builder.add((Object)new IndentedLine(8, (Component)Component.translatable((String)this.canUltimineStatus.getTranslationKey()).withStyle(style -> style.withColor(TextColor.fromRgb((int)12542314)))));
        }
        ShapeRegistry shapeRegistry = ShapeRegistry.INSTANCE;
        int context = Math.min((shapeRegistry.shapeCount() - 1) / 2, (Integer)FTBUltimineClientConfig.SHAPE_MENU_CONTEXT_LINES.get());
        boolean showingMenu = this.isMenuSneaking();
        if (showingMenu) {
            if (isActive) {
                builder.add((Object)new IndentedLine(0, (Component)Component.empty()));
            }
            for (i = -context; i < 0; ++i) {
                builder.add((Object)new IndentedLine(16, (Component)shapeRegistry.getShape(this.shapeIdx + i).getDisplayName().withStyle(ChatFormatting.GRAY)));
            }
        } else {
            builder.add((Object)new IndentedLine(0, (Component)Component.translatable((String)"ftbultimine.change_shape.short").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC})));
            builder.add((Object)new IndentedLine(0, (Component)Component.empty()));
        }
        builder.add((Object)new IndentedLine(showingMenu ? 16 : 0, (Component)shapeRegistry.getShape(this.shapeIdx).getDisplayName().withStyle(ChatFormatting.YELLOW)));
        if (showingMenu) {
            for (i = 1; i <= context; ++i) {
                builder.add((Object)new IndentedLine(16, (Component)shapeRegistry.getShape(this.shapeIdx + i).getDisplayName().withStyle(ChatFormatting.GRAY)));
            }
        }
        if (this.canUltimine && this.actualBlocks != 0) {
            MutableComponent mining = Component.empty();
            mining.append((Component)Component.translatable((String)"ftbultimine.info.blocks", (Object[])new Object[]{this.actualBlocks}));
            if (this.actualBlocks > this.shapeBlocks.size()) {
                mining.append(", ").append((Component)Component.translatable((String)"ftbultimine.info.partial_render", (Object[])new Object[]{this.shapeBlocks.size()}));
            }
            builder.add((Object)new IndentedLine(0, (Component)Component.empty()));
            builder.add((Object)new IndentedLine(0, (Component)mining.withColor(10731148)));
        }
        return builder.build();
    }

    public void renderGameOverlay(GuiGraphics graphics, DeltaTracker tickDelta) {
        if (this.pressed) {
            int width;
            Minecraft mc = Minecraft.getInstance();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            Font font = mc.font;
            this.maxPanelWidth = width = Math.max(this.maxPanelWidth, 10 + this.infoPanelList.stream().map(l -> font.width((FormattedText)l.text)).max(Integer::compareTo).orElse(100));
            Objects.requireNonNull(font);
            int height = 9 * this.infoPanelList.size();
            float scale = 1.0f;
            int insetX = (Integer)FTBUltimineClientConfig.OVERLAY_INSET_X.get();
            int insetY = (Integer)FTBUltimineClientConfig.OVERLAY_INSET_Y.get();
            PanelPositioning.PanelPos pos = ((PanelPositioning)FTBUltimineClientConfig.OVERLAY_POS.get()).getPanelPos(mc.getWindow().getGuiScaledWidth(), mc.getWindow().getGuiScaledHeight(), (int)((float)width * scale), (int)((float)height * scale), insetX, insetY);
            graphics.pose().pushPose();
            graphics.pose().translate((float)pos.x(), (float)pos.y(), 100.0f);
            graphics.pose().scale(scale, scale, 1.0f);
            Color4I.DARK_GRAY.withAlpha(128).draw(graphics, -2, -2, width + 4, height + 4);
            GuiHelper.drawHollowRect((GuiGraphics)graphics, (int)-2, (int)-2, (int)(width + 4), (int)(height + 4), (Color4I)Color4I.GRAY.withAlpha(128), (boolean)false);
            float f = CooldownTracker.getCooldownRemaining(FTBUltimineClient.getClientPlayer());
            if (f < 1.0f) {
                Color4I color4I = Color4I.rgba((int)-1438605248);
                int n = (int)((float)width * f) + 1;
                Objects.requireNonNull(font);
                color4I.draw(graphics, 0, 0, n, 9 + 1);
            }
            if (this.isMenuSneaking()) {
                Objects.requireNonNull(font);
                int barUpper = 9 * 2;
                Objects.requireNonNull(font);
                int barHeight = 9 * (ShapeRegistry.INSTANCE.shapeCount() - 1) - 2;
                Color4I col = Color4I.WHITE.withAlpha(192);
                col.draw(graphics, 3, barUpper, 2, barHeight);
                col.draw(graphics, 2, barUpper + 1, 4, 1);
                col.draw(graphics, 1, barUpper + 2, 6, 1);
                col.draw(graphics, 2, barUpper + barHeight - 2, 4, 1);
                col.draw(graphics, 1, barUpper + barHeight - 3, 6, 1);
            }
            int top = 0;
            for (IndentedLine line : this.infoPanelList) {
                FormattedCharSequence formatted = line.text.getVisualOrderText();
                graphics.drawString(font, formatted, line.indent, top, 15527924, true);
                Objects.requireNonNull(font);
                top += 9;
            }
            graphics.pose().popPose();
        }
    }

    public void clientTick(Minecraft mc) {
        BlockHitResult b;
        HitResult hitResult;
        if (Minecraft.getInstance().player == null) {
            return;
        }
        boolean p = this.pressed;
        this.pressed = keyBindUltimine.isDown();
        if (this.pressed != p) {
            NetworkManager.sendToServer((CustomPacketPayload)new KeyPressedPacket(this.pressed));
            if (this.pressed && !this.hasScrolledYet && mc.player != null) {
                MutableComponent msg1 = Component.translatable((String)((Boolean)FTBUltimineClientConfig.REQUIRE_SNEAK_FOR_MENU.get() != false ? "ftbultimine.change_shape" : "ftbultimine.change_shape.no_shift"));
                mc.player.displayClientMessage((Component)msg1, true);
            }
        }
        this.canUltimineStatus = (hitResult = mc.hitResult) instanceof BlockHitResult && (b = (BlockHitResult)hitResult).getType() == HitResult.Type.BLOCK ? FTBUltimine.instance.canUltimine((Player)mc.player, b.getBlockPos(), mc.player.level().getBlockState(b.getBlockPos())) : CanUltimineResult.NO_BLOCK_TARGETED;
        boolean bl = this.canUltimine = this.pressed && this.canUltimineStatus.isAllowed();
        if (this.pressed) {
            this.infoPanelList = this.addPressedInfo();
        }
    }

    private void updateEdges() {
        if (this.cachedEdges != null) {
            return;
        }
        if (this.shapeBlocks.isEmpty()) {
            this.cachedEdges = Collections.emptyList();
            return;
        }
        this.cachedPos = this.shapeBlocks.getFirst();
        double d = 0.005;
        this.cachedEdges = new ArrayList<CachedEdge>();
        HashSet<VoxelShape> shapes = new HashSet<VoxelShape>();
        for (AABB aabb : ShapeMerger.merge(this.shapeBlocks, this.cachedPos)) {
            shapes.add(Shapes.create((AABB)aabb.inflate(d)));
        }
        FTBUltimineClient.orShapes(shapes).forAllEdges((x1, y1, z1, x2, y2, z2) -> {
            CachedEdge edge = new CachedEdge();
            edge.x1 = (float)x1;
            edge.y1 = (float)y1;
            edge.z1 = (float)z1;
            edge.x2 = (float)x2;
            edge.y2 = (float)y2;
            edge.z2 = (float)z2;
            this.cachedEdges.add(edge);
        });
    }

    static VoxelShape orShapes(Collection<VoxelShape> shapes) {
        VoxelShape combinedShape = Shapes.empty();
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.joinUnoptimized((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)BooleanOp.OR);
        }
        return combinedShape;
    }

    private record IndentedLine(int indent, Component text) {
    }
}

