/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.core.util.Nullability;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jspecify.annotations.Nullable;

public final class OptionScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"textures/gui/blank_screen.png");
    public static final int BUTTON_WIDTH = 100;
    public static final int BUTTON_HEIGHT = 20;
    private static final int PADDING = 16;
    private static final int FONT_HEIGHT = 9;
    private int x;
    private int y;
    private int innerWidth;
    private int innerHeight;
    private @Nullable MultiLineLabel messageRenderer;
    private final Component message;
    private final List<AbstractWidget> buttons;
    private final Runnable exit;
    private final Screen originalScreen;

    private OptionScreen(Component title, Component message, List<AbstractWidget> buttons, Runnable exit, Screen originalScreen) {
        super(title);
        this.message = message;
        this.buttons = buttons;
        this.exit = exit;
        this.originalScreen = originalScreen;
    }

    public static void show(Minecraft minecraft, Component title, Component message, List<AbstractWidget> buttons, Runnable exit) {
        minecraft.setScreen((Screen)new OptionScreen(title, message, buttons, exit, OptionScreen.unwrap(minecraft.screen)));
    }

    public static Screen unwrap(Screen screen) {
        Screen screen2;
        if (screen instanceof OptionScreen) {
            OptionScreen option = (OptionScreen)screen;
            screen2 = option.getOriginalScreen();
        } else {
            screen2 = screen;
        }
        return screen2;
    }

    public void init() {
        super.init();
        int buttonWidth = 100 * this.buttons.size() + 16 * (this.buttons.size() - 1);
        int innerWidth = this.innerWidth = Math.max(256, buttonWidth + 32);
        this.messageRenderer = MultiLineLabel.create((Font)this.font, (Component)this.message, (int)(innerWidth - 32));
        int textHeight = this.messageRenderer.getLineCount() * 9 + 32;
        this.innerHeight = textHeight + (this.buttons.isEmpty() ? 0 : this.buttons.get(0).getHeight()) + 16;
        this.x = (this.width - innerWidth) / 2;
        this.y = (this.height - this.innerHeight) / 2;
        int x = (this.width - buttonWidth) / 2;
        for (AbstractWidget button : this.buttons) {
            button.setPosition(x, this.y + textHeight);
            this.addRenderableWidget((GuiEventListener)button);
            x += 116;
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blit(BACKGROUND, this.x, this.y, 0, 0, this.innerWidth, 16);
        graphics.blit(BACKGROUND, this.x, this.y + 16, 0.0f, 16.0f, this.innerWidth, this.innerHeight - 32, this.innerWidth, 16);
        graphics.blit(BACKGROUND, this.x, this.y + this.innerHeight - 16, 0, 240, this.innerWidth, 16);
        Nullability.assertNonNull(this.messageRenderer).renderLeftAlignedNoShadow(graphics, this.x + 16, this.y + 16, 9, 0x404040);
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    public void onClose() {
        this.exit.run();
    }

    public static AbstractWidget newButton(Component component, Button.OnPress clicked) {
        return Button.builder((Component)component, (Button.OnPress)clicked).bounds(0, 0, 100, 20).build();
    }

    public Screen getOriginalScreen() {
        return this.originalScreen;
    }
}

