/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.shared.common.IBundledRedstoneBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public final class MoreRedIntegration {
    public static final String MOD_ID = "morered";

    private static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        for (Block block : BuiltInRegistries.BLOCK) {
            if (!(block instanceof IBundledRedstoneBlock)) continue;
            IBundledRedstoneBlock bundledBlock = (IBundledRedstoneBlock)block;
            event.registerBlock(MoreRedAPI.CHANNELED_POWER_CAPABILITY, (level, pos, state, blockEntity, context) -> (level2, wirePos, wireState, wireFace, channel) -> {
                int outputLevel = bundledBlock.getBundledRedstoneOutput(level2, pos, (Direction)context);
                return (outputLevel & 1 << channel) != 0 ? 31 : 0;
            }, new Block[]{block});
        }
    }

    public static void setup(IEventBus bus) {
        bus.addListener(MoreRedIntegration::onRegisterCapabilities);
        ComputerCraftAPI.registerBundledRedstoneProvider(MoreRedIntegration::getBundledPower);
    }

    private static int getBundledPower(Level world, BlockPos pos, Direction side) {
        BlockState blockState = world.getBlockState(pos);
        if (blockState.getBlock() instanceof IBundledRedstoneBlock) {
            return -1;
        }
        ChanneledPowerSupplier power = (ChanneledPowerSupplier)world.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, pos, blockState, null, (Object)side);
        if (power == null) {
            return -1;
        }
        int mask = 0;
        for (int i = 0; i < 16; ++i) {
            mask |= power.getPowerOnChannel(world, pos, blockState, side, i) > 0 ? 1 << i : 0;
        }
        return mask;
    }
}

