/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.printer;

import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.container.ValidatingSlot;
import dan200.computercraft.shared.peripheral.printer.PrinterBlockEntity;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class PrinterMenu
extends AbstractContainerMenu {
    private final Container inventory;
    private final ContainerData properties;

    private PrinterMenu(int id, Inventory player, Container inventory, ContainerData properties) {
        super((MenuType)ModRegistry.Menus.PRINTER.get(), id);
        int x;
        this.properties = properties;
        this.inventory = inventory;
        this.addDataSlots(properties);
        this.addSlot(new ValidatingSlot(inventory, 0, 13, 35, PrinterBlockEntity::isInk));
        for (x = 0; x < 6; ++x) {
            this.addSlot(new ValidatingSlot(inventory, x + 1, 61 + x * 18, 22, PrinterBlockEntity::isPaper));
        }
        for (x = 0; x < 6; ++x) {
            this.addSlot(new ValidatingSlot(inventory, x + 7, 61 + x * 18, 49, o -> false));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.addSlot(new Slot((Container)player, x2 + y * 9 + 9, 8 + x2 * 18, 84 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)player, x, 8 + x * 18, 142));
        }
    }

    public PrinterMenu(int id, Inventory player) {
        this(id, player, (Container)new SimpleContainer(13), (ContainerData)new SimpleContainerData(1));
    }

    public PrinterMenu(int id, Inventory player, PrinterBlockEntity printer) {
        this(id, player, printer, () -> printer.isPrinting() ? 1 : 0);
    }

    public boolean isPrinting() {
        return this.properties.get(0) != 0;
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack result = stack.copy();
        if (index < 13 ? !this.moveItemStackTo(stack, 13, 49, true) : (PrinterBlockEntity.isInk(stack) ? !this.moveItemStackTo(stack, 0, 1, false) : !this.moveItemStackTo(stack, 1, 13, false))) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == result.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stack);
        return result;
    }
}

