/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.block.BlockTileEntity;
import stepsword.mahoutsukai.dataattachments.chunks.IChunkMahou;
import stepsword.mahoutsukai.datacomponents.fog.FogProjectorEnchant;
import stepsword.mahoutsukai.networking.ChunkMahouPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.tile.FogProjectorTileEntity;
import stepsword.mahoutsukai.util.ChunkDim;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.FogProjectorValues;
import stepsword.mahoutsukai.util.Utils;

public class FogProjector
extends BlockTileEntity<FogProjectorTileEntity> {
    public static final AABB boundingBox = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AABB boundingBoxE = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static HashSet<ChunkDim> projectors = new HashSet();

    public FogProjector() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).noOcclusion(), "fog_projector");
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (level.isClientSide) {
            MahouTsukaiMod.proxy.openFogProjectorGUI(level, pos);
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        FogProjectorTileEntity te = (FogProjectorTileEntity)level.getBlockEntity(pos);
        if (!level.isClientSide && stack.getItem() == Items.STICK) {
            if (player.isDiscrete()) {
                if (Utils.hasFogProjectorEnchant(stack)) {
                    FogProjectorValues pv = Utils.getFogProjectorEnchant(stack).getPv();
                    if (te != null) {
                        te.set_particle_fog_size(pv.get_particle_fog_size());
                        te.set_particle_fog_color_r(pv.get_particle_fog_color_r());
                        te.set_particle_fog_color_g(pv.get_particle_fog_color_g());
                        te.set_particle_fog_color_b(pv.get_particle_fog_color_b());
                        te.set_particle_fog_color_a(pv.get_particle_fog_color_a());
                        te.set_particle_fog_thickness(pv.get_particle_fog_thickness());
                        te.set_particle_fog_speed(pv.get_particle_fog_speed());
                        te.set_particle_fog_random_x(pv.get_particle_fog_random_x());
                        te.set_particle_fog_random_y(pv.get_particle_fog_random_y());
                        te.set_particle_fog_random_z(pv.get_particle_fog_random_z());
                        te.set_particle_fog_direction_x(pv.get_particle_fog_direction_x());
                        te.set_particle_fog_direction_y(pv.get_particle_fog_direction_y());
                        te.set_particle_fog_direction_z(pv.get_particle_fog_direction_z());
                        te.set_particle_fog_shaders(pv.get_particle_fog_shaders());
                        te.set_particle_fog_frequency_num(pv.get_particle_fog_frequency_num());
                        te.set_particle_fog_frequency_ticks(pv.get_particle_fog_frequency_ticks());
                        te.set_camera_fog_radius(pv.get_camera_fog_radius());
                        te.set_camera_fog_color_r(pv.get_camera_fog_color_r());
                        te.set_camera_fog_color_g(pv.get_camera_fog_color_g());
                        te.set_camera_fog_color_b(pv.get_camera_fog_color_b());
                        te.set_camera_fog_strength(pv.get_camera_fog_strength());
                        te.set_camera_fog_toggle(pv.get_camera_fog_toggle());
                        te.sendUpdates();
                    }
                }
            } else {
                Utils.setFogProjectorEnchant(stack, new FogProjectorEnchant(new FogProjectorValues(new ArrayList<Integer>(Arrays.asList(te.get_particle_fog_color_r(), te.get_particle_fog_color_g(), te.get_particle_fog_color_b(), te.get_particle_fog_color_a(), te.get_particle_fog_frequency_num(), te.get_particle_fog_frequency_ticks(), te.get_camera_fog_color_r(), te.get_camera_fog_color_g(), te.get_camera_fog_color_b())), new ArrayList<Float>(Arrays.asList(Float.valueOf(te.get_particle_fog_size()), Float.valueOf(te.get_particle_fog_thickness()), Float.valueOf(te.get_particle_fog_speed()), Float.valueOf(te.get_particle_fog_direction_x()), Float.valueOf(te.get_particle_fog_direction_y()), Float.valueOf(te.get_particle_fog_direction_z()), Float.valueOf(te.get_camera_fog_radius()), Float.valueOf(te.get_camera_fog_strength()))), new ArrayList<Boolean>(Arrays.asList(te.get_particle_fog_shaders(), te.get_particle_fog_random_x(), te.get_particle_fog_random_y(), te.get_particle_fog_random_z(), te.get_camera_fog_toggle())))));
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public Class<FogProjectorTileEntity> getTileEntityClass() {
        return FogProjectorTileEntity.class;
    }

    @Nullable
    public FogProjectorTileEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new FogProjectorTileEntity(blockPos, blockState);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState state2, boolean v1) {
        if (!world.isClientSide) {
            IChunkMahou chunkMahou;
            ChunkAccess c = world.getChunk(pos);
            if (c instanceof LevelChunk && (chunkMahou = Utils.getChunkMahou((LevelChunk)c)) != null && chunkMahou.getFogProjectors() != null) {
                chunkMahou.getFogProjectors().remove((Object)pos);
            }
            if (projectors == null) {
                projectors = new HashSet();
            }
            projectors.add(new ChunkDim(c.getPos(), EffectUtil.getDimension(world)));
        }
        super.onRemove(state, world, pos, state2, v1);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!world.isClientSide) {
            IChunkMahou chunkMahou;
            ChunkAccess c = world.getChunk(pos);
            if (c instanceof LevelChunk && (chunkMahou = Utils.getChunkMahou((LevelChunk)c)) != null && chunkMahou.getFogProjectors() != null) {
                chunkMahou.getFogProjectors().add((Object)pos);
            }
            if (projectors == null) {
                projectors = new HashSet();
            }
            projectors.add(new ChunkDim(c.getPos(), EffectUtil.getDimension(world)));
        }
        super.onPlace(state, world, pos, oldState, isMoving);
    }

    public static void fogUpdateTick(LevelTickEvent.Post event) {
        if (!event.getLevel().isClientSide && event.getLevel().getGameTime() % 4L == 0L) {
            for (ChunkDim p : projectors) {
                ServerLevel world = EffectUtil.getNewDimensionByName((ServerLevel)event.getLevel(), p.dim);
                LevelChunk c = world.getChunk(p.pos.x, p.pos.z);
                IChunkMahou chunkMahou = Utils.getChunkMahou(c);
                if (chunkMahou == null) continue;
                PacketHandler.sendTrackingBlock(p.pos.getWorldPosition(), (Level)EffectUtil.getNewDimensionByName((ServerLevel)event.getLevel(), p.dim), new ChunkMahouPacket(chunkMahou.getFogProjectors(), p.pos.x, p.pos.z, 1));
            }
            projectors.clear();
        }
    }
}

