/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block.circuits;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import stepsword.mahoutsukai.block.BlockTileEntity;
import stepsword.mahoutsukai.block.circuits.ManaCircuitBlock;
import stepsword.mahoutsukai.tile.circuits.ManaCircuitMagitechTileEntity;

public class ManaCircuitMagitechBlock
extends BlockTileEntity<ManaCircuitMagitechTileEntity> {
    public static final AABB boundingBox = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final EnumProperty<Direction> FACING = DirectionProperty.create((String)"opposite", Direction.class);
    private static final DirectionProperty FACING_HORIZ = HorizontalDirectionalBlock.FACING;

    public ManaCircuitMagitechBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS), "mana_circuit_magitech");
    }

    @Override
    public Class<ManaCircuitMagitechTileEntity> getTileEntityClass() {
        return ManaCircuitMagitechTileEntity.class;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ManaCircuitMagitechTileEntity(blockPos, blockState);
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player playerIn, BlockHitResult result) {
        return ManaCircuitBlock.chargeCircuitBlock(worldIn, pos, playerIn) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)super.getStateForPlacement(ctx).setValue(FACING, (Comparable)ctx.getClickedFace())).setValue((Property)FACING_HORIZ, (Comparable)ctx.getHorizontalDirection());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FACING_HORIZ});
    }
}

