/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import stepsword.mahoutsukai.item.clarent.Clarent;
import stepsword.mahoutsukai.render.RenderUtils;

public class ClarentClientEffect {
    public static void clarentRenderPlayer(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (player.getUseItem().getItem() instanceof Clarent && player.getUsedItemHand() == InteractionHand.MAIN_HAND) {
            ModelPart rightArm = ((PlayerModel)event.getRenderer().getModel()).rightArm;
            ((PlayerModel)event.getRenderer().getModel()).rightArm.visible = false;
            ((PlayerModel)event.getRenderer().getModel()).rightSleeve.visible = false;
            RenderUtils.render(player.getUseItem(), false);
            rightArm.x = -Mth.cos((float)((float)Math.toRadians(player.yBodyRot - 5.0f))) * 7.0f;
            rightArm.y = player.isDiscrete() ? 17.0f : 20.0f;
            rightArm.z = -Mth.sin((float)((float)Math.toRadians(player.yBodyRot - 5.0f))) * 7.0f;
            rightArm.xRot = (float)Math.toRadians(-45.0);
            rightArm.yRot = (float)(-Math.toRadians(player.yBodyRot)) + 2.8f;
        }
    }

    public static void clarentRenderPlayer(RenderPlayerEvent.Post event) {
        PoseStack m = event.getPoseStack();
        Player player = event.getEntity();
        if (player.getUseItem().getItem() instanceof Clarent && player.getUsedItemHand() == InteractionHand.MAIN_HAND) {
            m.pushPose();
            ModelPart rightArm = ((PlayerModel)event.getRenderer().getModel()).rightArm;
            ModelPart rightArmwear = ((PlayerModel)event.getRenderer().getModel()).rightSleeve;
            RenderUtils.render(player.getUseItem(), true);
            double swing = 0.0;
            rightArm.x = -Mth.cos((float)((float)Math.toRadians(player.yBodyRot - 5.0f))) * 7.0f;
            rightArm.y = player.isDiscrete() ? 17.0f : 20.0f;
            rightArm.z = -Mth.sin((float)((float)Math.toRadians(player.yBodyRot - 5.0f))) * 7.0f;
            rightArm.xRot = (float)Math.toRadians(-45.0);
            rightArm.yRot = (float)((double)((float)(-Math.toRadians(player.yBodyRot)) + 2.8f) + swing);
            VertexConsumer buffer = event.getMultiBufferSource().getBuffer(((PlayerModel)event.getRenderer().getModel()).renderType(((AbstractClientPlayer)player).getSkin().texture()));
            int light = event.getPackedLight();
            int texture = OverlayTexture.NO_OVERLAY;
            ClarentClientEffect.applyBobbing(m, event.getPartialTick());
            rightArm.visible = true;
            rightArmwear.visible = true;
            rightArmwear.copyFrom(rightArm);
            rightArm.render(m, buffer, light, texture);
            ClarentClientEffect.renderItem(event.getRenderer().getModel(), m, event.getMultiBufferSource(), light, (LivingEntity)player, false);
            m.popPose();
        }
    }

    public static void applyBobbing(PoseStack matrixStackIn, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.getCameraEntity() instanceof Player) {
            Player Player2 = (Player)mc.getCameraEntity();
            float f = Player2.walkDist - Player2.walkDistO;
            float f1 = -(Player2.walkDist + f * partialTicks);
            float f2 = Mth.lerp((float)partialTicks, (float)Player2.oBob, (float)Player2.bob);
            matrixStackIn.translate((double)(Mth.sin((float)(f1 * (float)Math.PI)) * f2 * 0.5f), (double)(-Math.abs(Mth.cos((float)(f1 * (float)Math.PI)) * f2)), 0.0);
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-Mth.sin((float)(f1 * (float)Math.PI)) * f2 * 3.0f));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(-Math.abs(Mth.cos((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f));
        }
    }

    public static void renderItem(EntityModel model, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, LivingEntity entitylivingbaseIn, boolean left) {
        ItemStack itemstack1;
        boolean flag = entitylivingbaseIn.getMainArm() == HumanoidArm.RIGHT;
        ItemStack itemstack = flag ? entitylivingbaseIn.getOffhandItem() : entitylivingbaseIn.getMainHandItem();
        ItemStack itemStack = itemstack1 = flag ? entitylivingbaseIn.getMainHandItem() : entitylivingbaseIn.getOffhandItem();
        if (!itemstack.isEmpty() || !itemstack1.isEmpty()) {
            matrixStackIn.pushPose();
            if (model.young) {
                float f = 0.5f;
                matrixStackIn.translate(0.0, 0.75, 0.0);
                matrixStackIn.scale(0.5f, 0.5f, 0.5f);
            }
            if (!left) {
                ClarentClientEffect.renderArmWithItem(model, entitylivingbaseIn, itemstack1, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, matrixStackIn, bufferIn, packedLightIn);
            } else {
                ClarentClientEffect.renderArmWithItem(model, entitylivingbaseIn, itemstack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, matrixStackIn, bufferIn, packedLightIn);
            }
            matrixStackIn.popPose();
        }
    }

    public static void renderArmWithItem(EntityModel model, LivingEntity p_229135_1_, ItemStack p_229135_2_, ItemDisplayContext p_229135_3_, HumanoidArm p_229135_4_, PoseStack p_229135_5_, MultiBufferSource p_229135_6_, int p_229135_7_) {
        if (!p_229135_2_.isEmpty()) {
            p_229135_5_.pushPose();
            ((HumanoidModel)model).translateToHand(p_229135_4_, p_229135_5_);
            p_229135_5_.mulPose(Axis.XP.rotationDegrees(-90.0f));
            p_229135_5_.mulPose(Axis.YP.rotationDegrees(180.0f));
            boolean flag = p_229135_4_ == HumanoidArm.LEFT;
            p_229135_5_.translate((double)((float)(flag ? -1 : 1) / 16.0f), 0.125, -0.625);
            Minecraft.getInstance().gameRenderer.itemInHandRenderer.renderItem(p_229135_1_, p_229135_2_, p_229135_3_, flag, p_229135_5_, p_229135_6_, p_229135_7_);
            p_229135_5_.popPose();
        }
    }
}

