/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.common.CommonHooks;
import stepsword.mahoutsukai.item.spells.secret.ripper.TheRipper;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.RipperUseEntityPacket;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;

public class RipperClientEffect {
    public static boolean lastWasMain = false;

    public static boolean ripperPlayerLeftClick(InputEvent.InteractionKeyMappingTriggered event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = Minecraft.getInstance().player;
        if (event.isAttack() && mc.hitResult != null && mc.gameMode != null && mc.level != null && player != null && player.getMainHandItem().getItem() instanceof TheRipper && player.getOffhandItem().getItem() instanceof TheRipper) {
            lastWasMain = !lastWasMain;
            InteractionHand hand = InteractionHand.MAIN_HAND;
            if (lastWasMain) {
                hand = InteractionHand.OFF_HAND;
            }
            switch (mc.hitResult.getType()) {
                case ENTITY: {
                    RipperClientEffect.attackEntity((Player)mc.player, ((EntityHitResult)mc.hitResult).getEntity(), hand);
                    event.setSwingHand(false);
                    break;
                }
                case BLOCK: {
                    BlockHitResult BlockHitResult2 = (BlockHitResult)mc.hitResult;
                    BlockPos blockpos = BlockHitResult2.getBlockPos();
                    if (!mc.level.isEmptyBlock(blockpos)) {
                        mc.gameMode.startDestroyBlock(blockpos, BlockHitResult2.getDirection());
                        break;
                    }
                }
                case MISS: {
                    if (mc.gameMode.hasMissTime()) {
                        mc.missTime = 10;
                    }
                    mc.player.resetAttackStrengthTicker();
                    CommonHooks.onEmptyLeftClick((Player)mc.player);
                }
            }
            player.swing(hand);
            event.setSwingHand(false);
            return true;
        }
        return false;
    }

    public static void attackEntity(Player playerIn, Entity targetEntity, InteractionHand hand) {
        ((LocalPlayer)playerIn).connection.send((Packet)new ServerboundSetCarriedItemPacket(playerIn.getInventory().selected));
        PacketHandler.sendToServer(new RipperUseEntityPacket(hand, targetEntity.getId()));
        if (Minecraft.getInstance().gameMode.getPlayerMode() != GameType.SPECTATOR) {
            TheRipper.attack(playerIn, targetEntity);
            playerIn.resetAttackStrengthTicker();
        }
    }

    public static boolean ripperRenderPlayer(Player player) {
        return EffectUtil.hasBuff((LivingEntity)player, ModEffects.RIPPER_INVISIBILITY);
    }
}

