/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.ClarentEffect;
import stepsword.mahoutsukai.effects.secret.GeasEffect;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.item.caliburn.Caliburn;
import stepsword.mahoutsukai.item.clarent.Clarent;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;

public class GateWeaponProjectileEntity
extends Arrow {
    public static final String entityName = "gate_weapon_projectile_entity";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_R2 = "MAHOUTSUKAI_COLOR_R2";
    private static final String TAG_COLOR_G2 = "MAHOUTSUKAI_COLOR_G2";
    private static final String TAG_COLOR_B2 = "MAHOUTSUKAI_COLOR_B2";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.defineId(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Float> PROGRESS = SynchedEntityData.defineId(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_R2 = SynchedEntityData.defineId(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G2 = SynchedEntityData.defineId(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B2 = SynchedEntityData.defineId(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.defineId(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.defineId(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private float progress = 0.0f;
    public float lastProgress = 0.0f;

    public GateWeaponProjectileEntity(Level worldIn) {
        super((EntityType)ModEntities.GATE_WEAPON_PROJECTILE.get(), worldIn);
        this.noCulling = true;
        this.setStack(new ItemStack((ItemLike)Items.IRON_SWORD));
    }

    public GateWeaponProjectileEntity(Level worldIn, double x, double y, double z, ItemStack stack, Entity e, float speed) {
        this(worldIn);
        this.noCulling = true;
        this.setPos(x, y, z);
        this.setStack(stack);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
        this.setOwner(e);
        this.setSpeed(speed);
    }

    public void setColor(float r, float g, float b, float a, float r2, float g2, float b2) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        this.entityData.set(COLOR_R2, (Object)Float.valueOf(r2));
        this.entityData.set(COLOR_G2, (Object)Float.valueOf(g2));
        this.entityData.set(COLOR_B2, (Object)Float.valueOf(b2));
        this.entityData.set(COLOR_A, (Object)Float.valueOf(a));
    }

    public float[] getTColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue(), ((Float)this.entityData.get(COLOR_A)).floatValue(), ((Float)this.entityData.get(COLOR_R2)).floatValue(), ((Float)this.entityData.get(COLOR_G2)).floatValue(), ((Float)this.entityData.get(COLOR_B2)).floatValue()};
    }

    public GateWeaponProjectileEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ITEM, (Object)new ItemStack((ItemLike)Items.IRON_SWORD));
        builder.define(PROGRESS, (Object)Float.valueOf(0.0f));
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_R2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A, (Object)Float.valueOf(1.0f));
        builder.define(SPEED, (Object)Float.valueOf((float)MTConfig.TREASURY_PROJECTION_SPEED));
        super.defineSynchedData(builder);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        if (this.getStack() != null) {
            nbt.put("stackNBT", this.getStack().save((HolderLookup.Provider)this.level().registryAccess()));
        }
        nbt.putFloat("progress", this.progress);
        float[] colors = this.getTColor();
        nbt.putFloat(TAG_COLOR_R, colors[0]);
        nbt.putFloat(TAG_COLOR_G, colors[1]);
        nbt.putFloat(TAG_COLOR_B, colors[2]);
        nbt.putFloat(TAG_COLOR_A, colors[3]);
        nbt.putFloat(TAG_COLOR_R2, colors[4]);
        nbt.putFloat(TAG_COLOR_G2, colors[5]);
        nbt.putFloat(TAG_COLOR_B2, colors[6]);
        super.addAdditionalSaveData(nbt);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        if (nbt.contains("stackNBT")) {
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)((CompoundTag)nbt.get("stackNBT"))).orElse(new ItemStack((ItemLike)Items.IRON_SWORD));
            stack.setCount(1);
            this.setStack(stack);
        }
        this.progress = nbt.getFloat("progress");
        this.setColor(nbt.getFloat(TAG_COLOR_R), nbt.getFloat(TAG_COLOR_G), nbt.getFloat(TAG_COLOR_B), nbt.getFloat(TAG_COLOR_A), nbt.getFloat(TAG_COLOR_R2), nbt.getFloat(TAG_COLOR_G2), nbt.getFloat(TAG_COLOR_B2));
        super.readAdditionalSaveData(nbt);
    }

    protected ItemStack getPickupItem() {
        return this.getStack();
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float v) {
        this.progress = v;
    }

    public static boolean shouldAvoid(Entity shooter, Entity target) {
        if (target instanceof LivingEntity && shooter instanceof Player) {
            return ContractMahoujinTileEntity.isImmuneToSpell(shooter.level(), shooter.getUUID(), target) || GeasEffect.hasGeas((Player)shooter, (LivingEntity)target);
        }
        return false;
    }

    protected void onHitEntity(EntityHitResult result) {
        double d = this.getDeltaMovement().length();
        Entity entity = result.getEntity();
        if (this.level() instanceof ServerLevel && !GateWeaponProjectileEntity.shouldAvoid(this.getOwner(), entity)) {
            SafeFakePlayer fake_player = new SafeFakePlayer((ServerLevel)this.level(), "faker");
            fake_player.setItemInHand(InteractionHand.MAIN_HAND, this.getPickupItem());
            fake_player.setOnGround(true);
            Caliburn.updateAttr(this.getPickupItem(), (Player)fake_player, EquipmentSlot.MAINHAND);
            fake_player.setPos(this.getX(), this.getY(), this.getZ());
            if (!(entity instanceof AbstractArrow)) {
                if (this.getStack().getItem() instanceof Clarent && this.getOwner() instanceof Player) {
                    int mana = ClarentEffect.getManaCostClarent(this.getStack(), (Player)this.getOwner());
                    PlayerManaManager.donateManaToFakePlayer(fake_player, (Player)this.getOwner(), mana);
                }
                fake_player.attackStrengthTicker = 1000;
                fake_player.attack(entity);
                if (entity instanceof LivingEntity) {
                    this.doPostHurtEffects((LivingEntity)entity);
                }
                Entity shooter = null;
                if (this.getOwner() != null && entity != (shooter = this.getOwner()) && entity instanceof Player && shooter instanceof ServerPlayer) {
                    ((ServerPlayer)shooter).connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                }
            }
        }
        this.playSound(SoundEvents.ARROW_HIT, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
    }

    public void tick() {
        this.tickDespawn();
        this.tickDespawn();
        this.lastProgress = this.getProgress();
        float progressCap = this.getProgressCap();
        if (this.getProgress() > progressCap) {
            super.tick();
            if (this.inGround && MTConfig.TREASURY_PROJECTION_DESPAWN_AFTER_LAND) {
                this.discard();
            }
        } else {
            if (this.inGround) {
                this.setProgress(this.getProgressCap() + 1.0f);
            }
            float speed = this.getProgressSpeed();
            this.setProgress(this.getProgress() + progressCap / speed);
            Vec3 z = this.getDeltaMovement();
            z = z.normalize().scale((double)(progressCap / speed));
            z = z.add(this.position());
            this.setPos(z.x, z.y, z.z);
        }
    }

    public void playerTouch(Player player) {
    }

    public float getSpeed() {
        return ((Float)this.getEntityData().get(SPEED)).floatValue();
    }

    public void setSpeed(float s) {
        this.getEntityData().set(SPEED, (Object)Float.valueOf(s));
    }

    public ItemStack getStack() {
        return (ItemStack)this.getEntityData().get(ITEM);
    }

    public void setStack(ItemStack stack) {
        this.getEntityData().set(ITEM, (Object)stack);
    }

    public AABB getBoundingBoxForCulling() {
        return new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public void setProgress() {
        this.setProgress(this.progress);
    }

    public float getProgressCap() {
        return 4.0f;
    }

    public float getProgressSpeed() {
        return (float)Math.max(MTConfig.TREASURY_PROJECTION_SPEED_MIN, (double)this.getSpeed());
    }
}

